package org.teamapps.cluster.message.protocol;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;

import java.io.IOException;

public class ClusterInfoServiceClient extends AbstractClusterServiceClient {

    public ClusterInfoServiceClient(ClusterServiceRegistry registry) {
        super(registry, "clusterInfoService");
    }

	public ClusterNodeData getHostInfo(ClusterNodeData value) {
		return executeClusterServiceMethod("getHostInfo", value, ClusterNodeData.getMessageDecoder());
	}

	public ClusterNodeData getHostInfo(ClusterNodeData value, String clusterNodeId) {
		return executeClusterServiceMethod(clusterNodeId, "getHostInfo", value, ClusterNodeData.getMessageDecoder());
	}



}