package org.teamapps.cluster.message.protocol;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.model.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import java.util.*;
import java.time.*;



public class ClusterLoadInfo extends Message {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<ClusterLoadInfo> decoder = new PojoObjectDecoder<ClusterLoadInfo>() {
		@Override
		public ClusterLoadInfo decode(DataInputStream dis, FileDataReader fileDataReader) {
			try {
				return new ClusterLoadInfo(dis, fileDataReader);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterLoadInfo instance", e);
			}
			return null;
		}

		@Override
		public ClusterLoadInfo decode(Element element, FileDataReader fileDataReader) {
			return new ClusterLoadInfo(element, fileDataReader);
		}

        @Override
        public ClusterLoadInfo decode(String xml, FileDataReader fileDataReader) {
            try {
                return new ClusterLoadInfo(xml, fileDataReader);
            } catch (Exception e) {
                LOGGER.error("Error creating ClusterLoadInfo instance", e);
            }
            return null;
        }

		@Override
		public ClusterLoadInfo defaultMessage() {
			return (ClusterLoadInfo) new ClusterLoadInfo().setDefaultValues(ClusterMessageProtocol.MODEL_COLLECTION);
		}

		@Override
		public ClusterLoadInfo remap(MessageRecord message) {
			return new ClusterLoadInfo(message, ClusterMessageProtocol.MODEL_COLLECTION);
		}

        @Override
        public String getMessageUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<ClusterLoadInfo> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ClusterMessageProtocol.MODEL_COLLECTION;
	}

    public static ClusterLoadInfo remap(MessageRecord message) {
        return new ClusterLoadInfo(message, ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "cluster.clusterLoadInfo";


	public ClusterLoadInfo() {
		super(ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public ClusterLoadInfo(MessageRecord message, ModelCollection modelCollection) {
		super(message, modelCollection);
	}

	public ClusterLoadInfo(DataInputStream dis) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterLoadInfo(DataInputStream dis, FileDataReader fileDataReader) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterLoadInfo(byte[] bytes) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterLoadInfo(byte[] bytes, FileDataReader fileDataReader) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterLoadInfo(Element element, FileDataReader fileDataReader) {
		super(element, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

    public ClusterLoadInfo(String xml, FileDataReader fileDataReader) throws Exception {
        super(xml, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
    }

	public int getLoad() {
		return getIntAttribute("load");
	}

	public ClusterLoadInfo setLoad(int value) {
		setIntAttribute("load", value);
		return this;
	}



}