package org.teamapps.cluster.message.protocol;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.model.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import java.util.HashMap;
import java.util.Map;
import static org.teamapps.message.protocol.message.MessageDefinition.readBase64Message;

public class ClusterMessageProtocol {

	public static final MessageModelCollection MODEL_COLLECTION = new MessageModelCollection("clusterMessageProtocol", "org.teamapps.cluster.message.protocol", 1);


    static {
		MessageDefinition clusterConfig = MODEL_COLLECTION.createModel("clusterConfig", "cluster.clusterConfig", 1, null, true);
		MessageDefinition clusterNodeData = MODEL_COLLECTION.createModel("clusterNodeData", "cluster.clusterNodeData", 1, null, true);
		MessageDefinition clusterMessageFilePart = MODEL_COLLECTION.createModel("clusterMessageFilePart", "cluster.clusterMessageFilePart", 1, null, true);
		MessageDefinition clusterInfo = MODEL_COLLECTION.createModel("clusterInfo", "cluster.clusterInfo", 1, null, true);
		MessageDefinition clusterNewPeerInfo = MODEL_COLLECTION.createModel("clusterNewPeerInfo", "cluster.clusterNewPeerInfo", 1, null, true);
		MessageDefinition clusterNodeShutDownInfo = MODEL_COLLECTION.createModel("clusterNodeShutDownInfo", "cluster.clusterNodeShutDownInfo", 1, null, true);
		MessageDefinition clusterAvailableServicesUpdate = MODEL_COLLECTION.createModel("clusterAvailableServicesUpdate", "cluster.clusterAvailableServicesUpdate", 1, null, true);
		MessageDefinition clusterConnectionRequest = MODEL_COLLECTION.createModel("clusterConnectionRequest", "cluster.clusterConnectionRequest", 1, null, true);
		MessageDefinition clusterConnectionResult = MODEL_COLLECTION.createModel("clusterConnectionResult", "cluster.clusterConnectionResult", 1, null, true);
		MessageDefinition clusterServiceMethodRequest = MODEL_COLLECTION.createModel("clusterServiceMethodRequest", "cluster.clusterServiceMethodRequest", 1, null, true);
		MessageDefinition clusterServiceMethodResult = MODEL_COLLECTION.createModel("clusterServiceMethodResult", "cluster.clusterServiceMethodResult", 1, null, true);
		MessageDefinition clusterServiceBroadcastMessage = MODEL_COLLECTION.createModel("clusterServiceBroadcastMessage", "cluster.clusterServiceBroadcastMessage", 1, null, true);
		MessageDefinition clusterLoadInfo = MODEL_COLLECTION.createModel("clusterLoadInfo", "cluster.clusterLoadInfo", 1, null, true);
		MessageDefinition clusterNodeSystemInfo = MODEL_COLLECTION.createModel("clusterNodeSystemInfo", "cluster.clusterNodeSystemInfo", 1, null, true);
		MessageDefinition clusterNewLeaderInfo = MODEL_COLLECTION.createModel("clusterNewLeaderInfo", "cluster.clusterNewLeaderInfo", 1, null, true);

		EnumDefinition clusterServiceMethodErrorType = MODEL_COLLECTION.createEnum("clusterServiceMethodErrorType", "NETWORK_ERROR", "SERVICE_EXCEPTION");

		clusterConfig.addAttribute("clusterSecret", 1, AttributeType.STRING, null, null, null);
		clusterConfig.addAttribute("nodeId", 2, AttributeType.STRING, null, null, null);
		clusterConfig.addAttribute("host", 3, AttributeType.STRING, null, null, null);
		clusterConfig.addAttribute("port", 4, AttributeType.INT, null, null, null);
		clusterConfig.addAttribute("leaderNode", 5, AttributeType.BOOLEAN, null, null, null);
		clusterConfig.addMultiReference("peerNodes", 6, null, clusterNodeData);

		clusterNodeData.addAttribute("nodeId", 1, AttributeType.STRING, null, null, null);
		clusterNodeData.addAttribute("host", 2, AttributeType.STRING, null, null, null);
		clusterNodeData.addAttribute("port", 3, AttributeType.INT, null, null, null);
		clusterNodeData.addAttribute("leaderNode", 4, AttributeType.BOOLEAN, null, null, null);

		clusterMessageFilePart.addAttribute("fileId", 1, AttributeType.STRING, null, null, null);
		clusterMessageFilePart.addAttribute("totalLength", 2, AttributeType.LONG, null, null, null);
		clusterMessageFilePart.addAttribute("initialMessage", 3, AttributeType.BOOLEAN, null, null, null);
		clusterMessageFilePart.addAttribute("lastMessage", 4, AttributeType.BOOLEAN, null, null, null);
		clusterMessageFilePart.addAttribute("data", 5, AttributeType.BYTE_ARRAY, null, null, null);

		clusterInfo.addSingleReference("localNode", 1, null, clusterNodeData);
		clusterInfo.addMultiReference("peerNodes", 2, null, clusterNodeData);

		clusterNewPeerInfo.addSingleReference("newPeer", 1, null, clusterNodeData);


		clusterAvailableServicesUpdate.addAttribute("services", 1, AttributeType.STRING_ARRAY, null, null, null);

		clusterConnectionRequest.addSingleReference("localNode", 1, null, clusterNodeData);
		clusterConnectionRequest.addAttribute("localServices", 2, AttributeType.STRING_ARRAY, null, null, null);
		clusterConnectionRequest.addSingleReference("leaderNode", 3, null, clusterNodeData);
		clusterConnectionRequest.addMultiReference("knownPeers", 4, null, clusterNodeData);

		clusterConnectionResult.addSingleReference("localNode", 1, null, clusterNodeData);
		clusterConnectionResult.addAttribute("accepted", 2, AttributeType.BOOLEAN, null, null, null);
		clusterConnectionResult.addSingleReference("leaderNode", 3, null, clusterNodeData);
		clusterConnectionResult.addMultiReference("knownPeers", 4, null, clusterNodeData);
		clusterConnectionResult.addAttribute("localServices", 5, AttributeType.STRING_ARRAY, null, null, null);
		clusterConnectionResult.addAttribute("knownServices", 6, AttributeType.STRING_ARRAY, null, null, null);

		clusterServiceMethodRequest.addAttribute("clusterTaskId", 1, AttributeType.LONG, null, null, null);
		clusterServiceMethodRequest.addAttribute("serviceName", 2, AttributeType.STRING, null, null, null);
		clusterServiceMethodRequest.addAttribute("methodName", 3, AttributeType.STRING, null, null, null);
		clusterServiceMethodRequest.addAttribute("requestMessage", 4, AttributeType.GENERIC_MESSAGE, null, null, null);

		clusterServiceMethodResult.addAttribute("clusterTaskId", 1, AttributeType.LONG, null, null, null);
		clusterServiceMethodResult.addAttribute("serviceName", 2, AttributeType.STRING, null, null, null);
		clusterServiceMethodResult.addAttribute("methodName", 3, AttributeType.STRING, null, null, null);
		clusterServiceMethodResult.addAttribute("resultMessage", 4, AttributeType.GENERIC_MESSAGE, null, null, null);
		clusterServiceMethodResult.addAttribute("error", 5, AttributeType.BOOLEAN, null, null, null);
		clusterServiceMethodResult.addEnum("errorType", clusterServiceMethodErrorType, 6, null);
		clusterServiceMethodResult.addAttribute("errorMessage", 7, AttributeType.STRING, null, null, null);
		clusterServiceMethodResult.addAttribute("errorStackTrace", 8, AttributeType.STRING, null, null, null);

		clusterServiceBroadcastMessage.addAttribute("serviceName", 1, AttributeType.STRING, null, null, null);
		clusterServiceBroadcastMessage.addAttribute("methodName", 2, AttributeType.STRING, null, null, null);
		clusterServiceBroadcastMessage.addAttribute("message", 3, AttributeType.GENERIC_MESSAGE, null, null, null);

		clusterLoadInfo.addAttribute("load", 1, AttributeType.INT, null, null, null);

		clusterNodeSystemInfo.addAttribute("detailedInfo", 1, AttributeType.STRING, null, null, null);
		clusterNodeSystemInfo.addAttribute("cpus", 2, AttributeType.INT, null, null, null);
		clusterNodeSystemInfo.addAttribute("cores", 3, AttributeType.INT, null, null, null);
		clusterNodeSystemInfo.addAttribute("threads", 4, AttributeType.INT, null, null, null);
		clusterNodeSystemInfo.addAttribute("memorySize", 5, AttributeType.LONG, null, null, null);

		clusterNewLeaderInfo.addSingleReference("leaderNode", 1, null, clusterNodeData);


		MODEL_COLLECTION.addMessageDecoder(clusterConfig.getObjectUuid(), ClusterConfig.getMessageDecoder());
		MODEL_COLLECTION.addMessageDecoder(clusterNodeData.getObjectUuid(), ClusterNodeData.getMessageDecoder());
		MODEL_COLLECTION.addMessageDecoder(clusterMessageFilePart.getObjectUuid(), ClusterMessageFilePart.getMessageDecoder());
		MODEL_COLLECTION.addMessageDecoder(clusterInfo.getObjectUuid(), ClusterInfo.getMessageDecoder());
		MODEL_COLLECTION.addMessageDecoder(clusterNewPeerInfo.getObjectUuid(), ClusterNewPeerInfo.getMessageDecoder());
		MODEL_COLLECTION.addMessageDecoder(clusterNodeShutDownInfo.getObjectUuid(), ClusterNodeShutDownInfo.getMessageDecoder());
		MODEL_COLLECTION.addMessageDecoder(clusterAvailableServicesUpdate.getObjectUuid(), ClusterAvailableServicesUpdate.getMessageDecoder());
		MODEL_COLLECTION.addMessageDecoder(clusterConnectionRequest.getObjectUuid(), ClusterConnectionRequest.getMessageDecoder());
		MODEL_COLLECTION.addMessageDecoder(clusterConnectionResult.getObjectUuid(), ClusterConnectionResult.getMessageDecoder());
		MODEL_COLLECTION.addMessageDecoder(clusterServiceMethodRequest.getObjectUuid(), ClusterServiceMethodRequest.getMessageDecoder());
		MODEL_COLLECTION.addMessageDecoder(clusterServiceMethodResult.getObjectUuid(), ClusterServiceMethodResult.getMessageDecoder());
		MODEL_COLLECTION.addMessageDecoder(clusterServiceBroadcastMessage.getObjectUuid(), ClusterServiceBroadcastMessage.getMessageDecoder());
		MODEL_COLLECTION.addMessageDecoder(clusterLoadInfo.getObjectUuid(), ClusterLoadInfo.getMessageDecoder());
		MODEL_COLLECTION.addMessageDecoder(clusterNodeSystemInfo.getObjectUuid(), ClusterNodeSystemInfo.getMessageDecoder());
		MODEL_COLLECTION.addMessageDecoder(clusterNewLeaderInfo.getObjectUuid(), ClusterNewLeaderInfo.getMessageDecoder());

    }



}