package org.teamapps.cluster.message.protocol;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.model.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import java.util.*;
import java.time.*;



public class ClusterNewLeaderInfo extends Message {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<ClusterNewLeaderInfo> decoder = new PojoObjectDecoder<ClusterNewLeaderInfo>() {
		@Override
		public ClusterNewLeaderInfo decode(DataInputStream dis, FileDataReader fileDataReader) {
			try {
				return new ClusterNewLeaderInfo(dis, fileDataReader);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterNewLeaderInfo instance", e);
			}
			return null;
		}

		@Override
		public ClusterNewLeaderInfo decode(Element element, FileDataReader fileDataReader) {
			return new ClusterNewLeaderInfo(element, fileDataReader);
		}

        @Override
        public ClusterNewLeaderInfo decode(String xml, FileDataReader fileDataReader) {
            try {
                return new ClusterNewLeaderInfo(xml, fileDataReader);
            } catch (Exception e) {
                LOGGER.error("Error creating ClusterNewLeaderInfo instance", e);
            }
            return null;
        }

		@Override
		public ClusterNewLeaderInfo defaultMessage() {
			return (ClusterNewLeaderInfo) new ClusterNewLeaderInfo().setDefaultValues(ClusterMessageProtocol.MODEL_COLLECTION);
		}

		@Override
		public ClusterNewLeaderInfo remap(MessageRecord message) {
			return new ClusterNewLeaderInfo(message, ClusterMessageProtocol.MODEL_COLLECTION);
		}

        @Override
        public String getMessageUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<ClusterNewLeaderInfo> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ClusterMessageProtocol.MODEL_COLLECTION;
	}

    public static ClusterNewLeaderInfo remap(MessageRecord message) {
        return new ClusterNewLeaderInfo(message, ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "cluster.clusterNewLeaderInfo";


	public ClusterNewLeaderInfo() {
		super(ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public ClusterNewLeaderInfo(MessageRecord message, ModelCollection modelCollection) {
		super(message, modelCollection);
	}

	public ClusterNewLeaderInfo(DataInputStream dis) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterNewLeaderInfo(DataInputStream dis, FileDataReader fileDataReader) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterNewLeaderInfo(byte[] bytes) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterNewLeaderInfo(byte[] bytes, FileDataReader fileDataReader) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterNewLeaderInfo(Element element, FileDataReader fileDataReader) {
		super(element, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

    public ClusterNewLeaderInfo(String xml, FileDataReader fileDataReader) throws Exception {
        super(xml, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
    }

	public ClusterNodeData getLeaderNode() {
		return getReferencedObjectAsType("leaderNode");
	}

	public ClusterNewLeaderInfo setLeaderNode(ClusterNodeData value) {
		setReferencedObjectAsType("leaderNode", value);
		return this;
	}



}