package org.teamapps.cluster.message.protocol;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.model.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import java.util.*;
import java.time.*;



public class ClusterNewPeerInfo extends Message {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<ClusterNewPeerInfo> decoder = new PojoObjectDecoder<ClusterNewPeerInfo>() {
		@Override
		public ClusterNewPeerInfo decode(DataInputStream dis, FileDataReader fileDataReader) {
			try {
				return new ClusterNewPeerInfo(dis, fileDataReader);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterNewPeerInfo instance", e);
			}
			return null;
		}

		@Override
		public ClusterNewPeerInfo decode(Element element, FileDataReader fileDataReader) {
			return new ClusterNewPeerInfo(element, fileDataReader);
		}

        @Override
        public ClusterNewPeerInfo decode(String xml, FileDataReader fileDataReader) {
            try {
                return new ClusterNewPeerInfo(xml, fileDataReader);
            } catch (Exception e) {
                LOGGER.error("Error creating ClusterNewPeerInfo instance", e);
            }
            return null;
        }

		@Override
		public ClusterNewPeerInfo defaultMessage() {
			return (ClusterNewPeerInfo) new ClusterNewPeerInfo().setDefaultValues(ClusterMessageProtocol.MODEL_COLLECTION);
		}

		@Override
		public ClusterNewPeerInfo remap(MessageRecord message) {
			return new ClusterNewPeerInfo(message, ClusterMessageProtocol.MODEL_COLLECTION);
		}

        @Override
        public String getMessageUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<ClusterNewPeerInfo> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ClusterMessageProtocol.MODEL_COLLECTION;
	}

    public static ClusterNewPeerInfo remap(MessageRecord message) {
        return new ClusterNewPeerInfo(message, ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "cluster.clusterNewPeerInfo";


	public ClusterNewPeerInfo() {
		super(ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public ClusterNewPeerInfo(MessageRecord message, ModelCollection modelCollection) {
		super(message, modelCollection);
	}

	public ClusterNewPeerInfo(DataInputStream dis) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterNewPeerInfo(DataInputStream dis, FileDataReader fileDataReader) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterNewPeerInfo(byte[] bytes) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterNewPeerInfo(byte[] bytes, FileDataReader fileDataReader) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterNewPeerInfo(Element element, FileDataReader fileDataReader) {
		super(element, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

    public ClusterNewPeerInfo(String xml, FileDataReader fileDataReader) throws Exception {
        super(xml, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
    }

	public ClusterNodeData getNewPeer() {
		return getReferencedObjectAsType("newPeer");
	}

	public ClusterNewPeerInfo setNewPeer(ClusterNodeData value) {
		setReferencedObjectAsType("newPeer", value);
		return this;
	}



}