package org.teamapps.cluster.message.protocol;

import org.teamapps.message.protocol.message.*;
import org.teamapps.message.protocol.model.*;
import org.teamapps.message.protocol.service.*;
import org.teamapps.message.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import java.util.*;
import java.time.*;



public class ClusterServiceBroadcastMessage extends Message {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<ClusterServiceBroadcastMessage> decoder = new PojoObjectDecoder<ClusterServiceBroadcastMessage>() {
		@Override
		public ClusterServiceBroadcastMessage decode(DataInputStream dis, FileDataReader fileDataReader) {
			try {
				return new ClusterServiceBroadcastMessage(dis, fileDataReader);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterServiceBroadcastMessage instance", e);
			}
			return null;
		}

		@Override
		public ClusterServiceBroadcastMessage decode(Element element, FileDataReader fileDataReader) {
			return new ClusterServiceBroadcastMessage(element, fileDataReader);
		}

        @Override
        public ClusterServiceBroadcastMessage decode(String xml, FileDataReader fileDataReader) {
            try {
                return new ClusterServiceBroadcastMessage(xml, fileDataReader);
            } catch (Exception e) {
                LOGGER.error("Error creating ClusterServiceBroadcastMessage instance", e);
            }
            return null;
        }

		@Override
		public ClusterServiceBroadcastMessage defaultMessage() {
			return (ClusterServiceBroadcastMessage) new ClusterServiceBroadcastMessage().setDefaultValues(ClusterMessageProtocol.MODEL_COLLECTION);
		}

		@Override
		public ClusterServiceBroadcastMessage remap(MessageRecord message) {
			return new ClusterServiceBroadcastMessage(message, ClusterMessageProtocol.MODEL_COLLECTION);
		}

        @Override
        public String getMessageUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<ClusterServiceBroadcastMessage> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ClusterMessageProtocol.MODEL_COLLECTION;
	}

    public static ClusterServiceBroadcastMessage remap(MessageRecord message) {
        return new ClusterServiceBroadcastMessage(message, ClusterMessageProtocol.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "cluster.clusterServiceBroadcastMessage";


	public ClusterServiceBroadcastMessage() {
		super(ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public ClusterServiceBroadcastMessage(MessageRecord message, ModelCollection modelCollection) {
		super(message, modelCollection);
	}

	public ClusterServiceBroadcastMessage(DataInputStream dis) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterServiceBroadcastMessage(DataInputStream dis, FileDataReader fileDataReader) throws IOException {
		super(dis, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterServiceBroadcastMessage(byte[] bytes) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterServiceBroadcastMessage(byte[] bytes, FileDataReader fileDataReader) throws IOException {
		super(bytes, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

	public ClusterServiceBroadcastMessage(Element element, FileDataReader fileDataReader) {
		super(element, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
	}

    public ClusterServiceBroadcastMessage(String xml, FileDataReader fileDataReader) throws Exception {
        super(xml, ClusterMessageProtocol.MODEL_COLLECTION.getModel(OBJECT_UUID), fileDataReader, ClusterMessageProtocol.MODEL_COLLECTION);
    }

	public String getServiceName() {
		return getStringAttribute("serviceName");
	}

	public ClusterServiceBroadcastMessage setServiceName(String value) {
		setStringAttribute("serviceName", value);
		return this;
	}

	public String getMethodName() {
		return getStringAttribute("methodName");
	}

	public ClusterServiceBroadcastMessage setMethodName(String value) {
		setStringAttribute("methodName", value);
		return this;
	}

	public Message getMessage() {
		return getGenericMessageAttribute("message");
	}

	public ClusterServiceBroadcastMessage setMessage(Message value) {
		setGenericMessageAttribute("message", value);
		return this;
	}



}