/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.dto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.cluster.dto.FileProvider;
import org.teamapps.cluster.dto.FileSink;
import org.teamapps.cluster.dto.MessageDecoder;
import org.teamapps.cluster.dto.MessageDecoderRegistry;
import org.teamapps.cluster.dto.MessageField;
import org.teamapps.cluster.dto.MessageFieldContentType;
import org.teamapps.cluster.dto.MessageFieldType;
import org.teamapps.cluster.dto.MessageModel;
import org.teamapps.cluster.dto.MessageUtils;

public class Message {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MessageField field;
    private Object value;
    public static Function<Message, byte[]> ENCODER = message -> {
        try {
            return message.toBytes();
        }
        catch (IOException e) {
            LOGGER.error("Error encoding message instance", (Throwable)e);
            return null;
        }
    };

    public static int getMessageFieldId(byte[] bytes) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
        return dis.readInt();
    }

    public Message(MessageField field, Object value) {
        this.field = field;
        this.value = value;
    }

    public Message(ByteBuffer buf, MessageModel model) {
        this(buf, model, null);
    }

    public Message(ByteBuffer buf, MessageModel model, FileProvider fileProvider) {
        int id = buf.getInt();
        this.field = model.getFieldById(id);
        switch (this.field.getType()) {
            case OBJECT: 
            case OBJECT_MULTI_REFERENCE: {
                ArrayList<Message> messages = new ArrayList<Message>();
                int messageCount = buf.getInt();
                for (int i = 0; i < messageCount; ++i) {
                    messages.add(new Message(buf, model));
                }
                this.value = messages;
                break;
            }
            case OBJECT_SINGLE_REFERENCE: {
                this.value = new Message(buf, model);
                break;
            }
            case BOOLEAN: {
                this.value = MessageUtils.readBoolean(buf);
                break;
            }
            case BYTE: {
                this.value = buf.get();
                break;
            }
            case INT: {
                this.value = buf.getInt();
                break;
            }
            case LONG: {
                this.value = buf.getLong();
                break;
            }
            case FLOAT: {
                this.value = Float.valueOf(buf.getFloat());
                break;
            }
            case DOUBLE: {
                this.value = buf.getDouble();
                break;
            }
            case STRING: {
                this.value = MessageUtils.readString(buf);
                break;
            }
            case BITSET: {
                this.value = MessageUtils.readBitSet(buf);
                break;
            }
            case BYTE_ARRAY: {
                this.value = MessageUtils.readByteArray(buf);
                break;
            }
            case INT_ARRAY: {
                this.value = MessageUtils.readIntArray(buf);
                break;
            }
            case LONG_ARRAY: {
                this.value = MessageUtils.readLongArray(buf);
                break;
            }
            case FLOAT_ARRAY: {
                this.value = MessageUtils.readFloatArray(buf);
                break;
            }
            case DOUBLE_ARRAY: {
                this.value = MessageUtils.readDoubleArray(buf);
                break;
            }
            case STRING_ARRAY: {
                this.value = MessageUtils.readStringArray(buf);
                break;
            }
            case FILE: {
                this.value = MessageUtils.readFile(buf, fileProvider);
            }
        }
    }

    public Message(DataInputStream dis, MessageModel model) throws IOException {
        this(dis, model, null);
    }

    public Message(DataInputStream dis, MessageModel model, FileProvider fileProvider) throws IOException {
        this(dis, model, fileProvider, null);
    }

    public Message(DataInputStream dis, MessageModel model, FileProvider fileProvider, MessageDecoderRegistry decoderRegistry) throws IOException {
        int id = dis.readInt();
        this.field = model.getFieldById(id);
        switch (this.field.getType()) {
            case OBJECT: 
            case OBJECT_MULTI_REFERENCE: {
                if (decoderRegistry != null && this.field.getType() == MessageFieldType.OBJECT_MULTI_REFERENCE && decoderRegistry.containsDecoder(this.field.getReferencedFieldId())) {
                    MessageDecoder<? extends Message> messageDecoder = decoderRegistry.getMessageDecoder(this.field.getReferencedFieldId());
                    ArrayList<Message> messages = new ArrayList<Message>();
                    int messageCount = dis.readInt();
                    for (int i = 0; i < messageCount; ++i) {
                        messages.add(messageDecoder.decode(dis, fileProvider));
                    }
                    this.value = messages;
                    break;
                }
                ArrayList<Message> messages = new ArrayList<Message>();
                int messageCount = dis.readInt();
                for (int i = 0; i < messageCount; ++i) {
                    messages.add(new Message(dis, model, fileProvider, decoderRegistry));
                }
                this.value = messages;
                break;
            }
            case OBJECT_SINGLE_REFERENCE: {
                if (decoderRegistry != null && decoderRegistry.containsDecoder(this.field.getReferencedFieldId())) {
                    MessageDecoder<? extends Message> messageDecoder = decoderRegistry.getMessageDecoder(this.field.getReferencedFieldId());
                    this.value = messageDecoder.decode(dis, fileProvider);
                    break;
                }
                this.value = new Message(dis, model, fileProvider);
                break;
            }
            case BOOLEAN: {
                this.value = dis.readBoolean();
                break;
            }
            case BYTE: {
                this.value = dis.readByte();
                break;
            }
            case INT: 
            case ENUM: {
                this.value = dis.readInt();
                break;
            }
            case LONG: {
                this.value = dis.readLong();
                break;
            }
            case FLOAT: {
                this.value = Float.valueOf(dis.readFloat());
                break;
            }
            case DOUBLE: {
                this.value = dis.readDouble();
                break;
            }
            case STRING: {
                this.value = MessageUtils.readString(dis);
                break;
            }
            case BITSET: {
                this.value = MessageUtils.readBitSet(dis);
                break;
            }
            case BYTE_ARRAY: {
                this.value = MessageUtils.readByteArray(dis);
                break;
            }
            case INT_ARRAY: {
                this.value = MessageUtils.readIntArray(dis);
                break;
            }
            case LONG_ARRAY: {
                this.value = MessageUtils.readLongArray(dis);
                break;
            }
            case FLOAT_ARRAY: {
                this.value = MessageUtils.readFloatArray(dis);
                break;
            }
            case DOUBLE_ARRAY: {
                this.value = MessageUtils.readDoubleArray(dis);
                break;
            }
            case STRING_ARRAY: {
                this.value = MessageUtils.readStringArray(dis);
                break;
            }
            case FILE: {
                this.value = MessageUtils.readFile(dis, fileProvider);
            }
        }
    }

    public Message(byte[] bytes, MessageModel model) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(bytes)), model);
    }

    public Message(byte[] bytes, MessageModel model, FileProvider fileProvider) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(bytes)), model, fileProvider);
    }

    public Message(byte[] bytes, MessageModel model, FileProvider fileProvider, MessageDecoderRegistry decoderRegistry) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(bytes)), model, fileProvider, decoderRegistry);
    }

    public void write(DataOutputStream dos) throws IOException {
        this.write(dos, null);
    }

    public void write(DataOutputStream dos, FileSink fileSink) throws IOException {
        dos.writeInt(this.field.getId());
        switch (this.field.getType()) {
            case OBJECT: 
            case OBJECT_MULTI_REFERENCE: {
                List<Message> messages = this.getMessageObjectValue();
                if (messages == null) {
                    dos.writeInt(0);
                    break;
                }
                dos.writeInt(messages.size());
                for (Message message : messages) {
                    message.write(dos, fileSink);
                }
                break;
            }
            case OBJECT_SINGLE_REFERENCE: {
                ((Message)this.getMessageObject()).write(dos, fileSink);
                break;
            }
            case BOOLEAN: {
                dos.writeBoolean(this.getBooleanValue());
                break;
            }
            case BYTE: {
                dos.writeByte(this.getByteValue());
                break;
            }
            case INT: 
            case ENUM: {
                dos.writeInt(this.getIntValue());
                break;
            }
            case LONG: {
                dos.writeLong(this.getLongValue());
                break;
            }
            case FLOAT: {
                dos.writeFloat(this.getFloatValue());
                break;
            }
            case DOUBLE: {
                dos.writeDouble(this.getDoubleValue());
                break;
            }
            case STRING: {
                MessageUtils.writeString(dos, this.getStringValue());
                break;
            }
            case BITSET: {
                MessageUtils.writeBitSet(dos, this.getBitSetValue());
                break;
            }
            case BYTE_ARRAY: {
                MessageUtils.writeByteArray(dos, this.getByteArrayValue());
                break;
            }
            case INT_ARRAY: {
                MessageUtils.writeIntArray(dos, this.getIntArrayValue());
                break;
            }
            case LONG_ARRAY: {
                MessageUtils.writeLongArray(dos, this.getLongArrayValue());
                break;
            }
            case FLOAT_ARRAY: {
                MessageUtils.writeFloatArray(dos, this.getFloatArrayValue());
                break;
            }
            case DOUBLE_ARRAY: {
                MessageUtils.writeDoubleArray(dos, this.getDoubleArrayValue());
                break;
            }
            case STRING_ARRAY: {
                MessageUtils.writeStringArray(dos, this.getStringArrayValue());
                break;
            }
            case FILE: {
                MessageUtils.writeFile(dos, this.getFileValue(), fileSink);
            }
        }
    }

    public byte[] toBytes() throws IOException {
        return this.toBytes(null);
    }

    public byte[] toBytes(FileSink fileSink) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos, fileSink);
        dos.close();
        return bos.toByteArray();
    }

    public MessageField getField() {
        return this.field;
    }

    public int getFieldId() {
        return this.field.getId();
    }

    private Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Message getMessageByFieldId(int id) {
        Object message2;
        if (this.field.getId() == id) {
            return this;
        }
        if (this.value != null && this.isObjectOrMultiReference()) {
            return this.getMessageObjectValue().stream().filter(message -> message.getField().getId() == id).findAny().orElse(null);
        }
        if (this.value != null && this.isObject() && ((Message)(message2 = this.getMessageObject())).getField().getId() == id) {
            return message2;
        }
        return null;
    }

    public Message getMessageByFieldName(String name) {
        Object message2;
        if (this.field.getName().equals(name)) {
            return this;
        }
        if (this.value != null && this.isObjectOrMultiReference()) {
            return this.getMessageObjectValue().stream().filter(message -> message.getField().getName().equals(name)).findAny().orElse(null);
        }
        if (this.value != null && this.isObject() && ((Message)(message2 = this.getMessageObject())).getField().getName().equals(name)) {
            return message2;
        }
        return null;
    }

    public void setPropertyValue(String name, Object value) {
        Message message = this.getMessageByFieldName(name);
        if (message != null) {
            message.setValue(value);
        } else {
            MessageField field = this.getField().getByName(name);
            if (field != null) {
                message = new Message(field, value);
                this.addMessage(message);
            } else {
                throw new RuntimeException("Cannot find field with name:" + name);
            }
        }
    }

    public void addMultiReference(String name, Message value) {
        Message message = this.getMessageByFieldName(name);
        if (message != null && message.isMultiReference()) {
            message.addMessage(value);
        } else {
            MessageField field = this.getField().getByName(name);
            if (field != null && field.isMultiReference()) {
                message = new Message(field, new ArrayList());
                this.addMessage(message);
                message.addMessage(value);
            } else {
                throw new RuntimeException("Cannot find object field with name:" + name);
            }
        }
    }

    public void setSingleReference(String name, Message value) {
        Message message = this.getMessageByFieldName(name);
        if (message != null && message.isSingleReference()) {
            message.setValue(value);
        } else {
            MessageField field = this.getField().getByName(name);
            if (field != null && field.isSingleReference()) {
                message = new Message(field, value);
                this.addMessage(message);
            } else {
                throw new RuntimeException("Cannot find object field with name:" + name);
            }
        }
    }

    protected void addMessage(Message message) {
        if (!this.isObjectOrMultiReference()) {
            throw new RuntimeException("Cannot add message to wrong field:" + this.field + ", message:" + message);
        }
        this.getMessageObjectValue().add(message);
    }

    protected boolean isObject() {
        return this.field.isObject();
    }

    protected boolean isObjectOrMultiReference() {
        return this.field.isObjectOrMultiReference();
    }

    protected boolean isObjectReference() {
        return this.field.isObjectReference();
    }

    protected boolean isSingleReference() {
        return this.field.isSingleReference();
    }

    protected boolean isMultiReference() {
        return this.field.isMultiReference();
    }

    protected Message getMessageValue() {
        if (this.value == null) {
            return null;
        }
        return (Message)this.value;
    }

    protected List<Message> getMessageObjectValue() {
        if (this.value == null) {
            return null;
        }
        return (List)this.value;
    }

    protected <TYPE extends Message> List<TYPE> getMessageList() {
        return (List)this.value;
    }

    protected <TYPE extends Message> TYPE getMessageObject() {
        return (TYPE)((Message)this.value);
    }

    protected boolean getBooleanValue() {
        if (this.value == null) {
            return false;
        }
        return (Boolean)this.value;
    }

    protected byte getByteValue() {
        if (this.value == null) {
            return 0;
        }
        return (Byte)this.value;
    }

    protected int getIntValue() {
        if (this.value == null) {
            return 0;
        }
        return (Integer)this.value;
    }

    protected long getLongValue() {
        if (this.value == null) {
            return 0L;
        }
        return (Long)this.value;
    }

    protected float getFloatValue() {
        if (this.value == null) {
            return 0.0f;
        }
        return ((Float)this.value).floatValue();
    }

    protected double getDoubleValue() {
        if (this.value == null) {
            return 0.0;
        }
        return (Double)this.value;
    }

    protected String getStringValue() {
        if (this.value == null) {
            return null;
        }
        return (String)this.value;
    }

    protected File getFileValue() {
        if (this.value == null) {
            return null;
        }
        return (File)this.value;
    }

    protected BitSet getBitSetValue() {
        if (this.value == null) {
            return null;
        }
        return (BitSet)this.value;
    }

    protected byte[] getByteArrayValue() {
        if (this.value == null) {
            return null;
        }
        return (byte[])this.value;
    }

    protected int[] getIntArrayValue() {
        if (this.value == null) {
            return null;
        }
        return (int[])this.value;
    }

    protected long[] getLongArrayValue() {
        if (this.value == null) {
            return null;
        }
        return (long[])this.value;
    }

    protected float[] getFloatArrayValue() {
        if (this.value == null) {
            return null;
        }
        return (float[])this.value;
    }

    protected double[] getDoubleArrayValue() {
        if (this.value == null) {
            return null;
        }
        return (double[])this.value;
    }

    protected String[] getStringArrayValue() {
        if (this.value == null) {
            return null;
        }
        return (String[])this.value;
    }

    public List<Message> getMessageObjectValue(String name) {
        Message message = this.getMessageByFieldName(name);
        if (message == null) {
            return null;
        }
        return message.getMessageObjectValue();
    }

    public <TYPE extends Message> TYPE getMessageObject(String name) {
        Message message = this.getMessageByFieldName(name);
        if (message == null) {
            return null;
        }
        return message.getMessageObject();
    }

    public <TYPE extends Message> List<TYPE> getMessageList(String name) {
        Message message = this.getMessageByFieldName(name);
        if (message == null) {
            return Collections.emptyList();
        }
        return message.getMessageList();
    }

    public boolean getBooleanValue(String name) {
        Message message = this.getMessageByFieldName(name);
        if (message == null) {
            return false;
        }
        return message.getBooleanValue();
    }

    public byte getByteValue(String name) {
        Message message = this.getMessageByFieldName(name);
        if (message == null) {
            return 0;
        }
        return message.getByteValue();
    }

    public int getIntValue(String name) {
        Message message = this.getMessageByFieldName(name);
        if (message == null) {
            return 0;
        }
        return message.getIntValue();
    }

    public long getLongValue(String name) {
        Message message = this.getMessageByFieldName(name);
        if (message == null) {
            return 0L;
        }
        return message.getLongValue();
    }

    public float getFloatValue(String name) {
        Message message = this.getMessageByFieldName(name);
        if (message == null) {
            return 0.0f;
        }
        return message.getFloatValue();
    }

    public double getDoubleValue(String name) {
        Message message = this.getMessageByFieldName(name);
        if (message == null) {
            return 0.0;
        }
        return message.getDoubleValue();
    }

    public String getStringValue(String name) {
        Message message = this.getMessageByFieldName(name);
        if (message == null) {
            return null;
        }
        return message.getStringValue();
    }

    public File getFileValue(String name) {
        Message message = this.getMessageByFieldName(name);
        if (message == null) {
            return null;
        }
        return message.getFileValue();
    }

    public BitSet getBitSetValue(String name) {
        Message message = this.getMessageByFieldName(name);
        if (message == null) {
            return null;
        }
        return message.getBitSetValue();
    }

    public byte[] getByteArrayValue(String name) {
        Message message = this.getMessageByFieldName(name);
        if (message == null) {
            return null;
        }
        return message.getByteArrayValue();
    }

    public int[] getIntArrayValue(String name) {
        Message message = this.getMessageByFieldName(name);
        if (message == null) {
            return null;
        }
        return message.getIntArrayValue();
    }

    public long[] getLongArrayValue(String name) {
        Message message = this.getMessageByFieldName(name);
        if (message == null) {
            return null;
        }
        return message.getLongArrayValue();
    }

    public float[] getFloatArrayValue(String name) {
        Message message = this.getMessageByFieldName(name);
        if (message == null) {
            return null;
        }
        return message.getFloatArrayValue();
    }

    public double[] getDoubleArrayValue(String name) {
        Message message = this.getMessageByFieldName(name);
        if (message == null) {
            return null;
        }
        return message.getDoubleArrayValue();
    }

    public String[] getStringArrayValue(String name) {
        Message message = this.getMessageByFieldName(name);
        if (message == null) {
            return null;
        }
        return message.getStringArrayValue();
    }

    public List<Message> getMessageObjectValue(int fieldId) {
        Message message = this.getMessageByFieldId(fieldId);
        if (message == null) {
            return null;
        }
        return message.getMessageObjectValue();
    }

    public boolean getBooleanValue(int fieldId) {
        Message message = this.getMessageByFieldId(fieldId);
        if (message == null) {
            return false;
        }
        return message.getBooleanValue();
    }

    public byte getByteValue(int fieldId) {
        Message message = this.getMessageByFieldId(fieldId);
        if (message == null) {
            return 0;
        }
        return message.getByteValue();
    }

    public int getIntValue(int fieldId) {
        Message message = this.getMessageByFieldId(fieldId);
        if (message == null) {
            return 0;
        }
        return message.getIntValue();
    }

    public long getLongValue(int fieldId) {
        Message message = this.getMessageByFieldId(fieldId);
        if (message == null) {
            return 0L;
        }
        return message.getLongValue();
    }

    public float getFloatValue(int fieldId) {
        Message message = this.getMessageByFieldId(fieldId);
        if (message == null) {
            return 0.0f;
        }
        return message.getFloatValue();
    }

    public double getDoubleValue(int fieldId) {
        Message message = this.getMessageByFieldId(fieldId);
        if (message == null) {
            return 0.0;
        }
        return message.getDoubleValue();
    }

    public String getStringValue(int fieldId) {
        Message message = this.getMessageByFieldId(fieldId);
        if (message == null) {
            return null;
        }
        return message.getStringValue();
    }

    public BitSet getBitSetValue(int fieldId) {
        Message message = this.getMessageByFieldId(fieldId);
        if (message == null) {
            return null;
        }
        return message.getBitSetValue();
    }

    public byte[] getByteArrayValue(int fieldId) {
        Message message = this.getMessageByFieldId(fieldId);
        if (message == null) {
            return null;
        }
        return message.getByteArrayValue();
    }

    public int[] getIntArrayValue(int fieldId) {
        Message message = this.getMessageByFieldId(fieldId);
        if (message == null) {
            return null;
        }
        return message.getIntArrayValue();
    }

    public long[] getLongArrayValue(int fieldId) {
        Message message = this.getMessageByFieldId(fieldId);
        if (message == null) {
            return null;
        }
        return message.getLongArrayValue();
    }

    public float[] getFloatArrayValue(int fieldId) {
        Message message = this.getMessageByFieldId(fieldId);
        if (message == null) {
            return null;
        }
        return message.getFloatArrayValue();
    }

    public double[] getDoubleArrayValue(int fieldId) {
        Message message = this.getMessageByFieldId(fieldId);
        if (message == null) {
            return null;
        }
        return message.getDoubleArrayValue();
    }

    public String[] getStringArrayValue(int fieldId) {
        Message message = this.getMessageByFieldId(fieldId);
        if (message == null) {
            return null;
        }
        return message.getStringArrayValue();
    }

    protected String explain(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t".repeat(level)).append(this.field.getName()).append(", ");
        if (this.field.getTitle() != null) {
            sb.append(this.field.getTitle()).append(", ");
        }
        sb.append(this.field.getId()).append(", ").append((Object)this.field.getType());
        if (this.field.isObjectReference()) {
            sb.append(" -> ").append(this.field.getReferencedFieldId());
        }
        sb.append((String)(this.field.getContentType() != MessageFieldContentType.GENERIC ? ", " + this.field.getContentType() : ""));
        if (this.value != null && this.field.isObjectOrMultiReference()) {
            sb.append("\n");
            this.getMessageObjectValue().forEach(message -> sb.append(message.explain(level + 1)));
        } else if (this.value != null && this.field.isSingleReference()) {
            sb.append("\n");
            sb.append(this.getMessageValue().explain(level + 1));
        } else {
            sb.append(": ").append(this.value).append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this.explain(0);
    }
}

