/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.dto;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.teamapps.cluster.dto.MessageFieldContentType;
import org.teamapps.cluster.dto.MessageFieldType;
import org.teamapps.cluster.dto.MessageModel;
import org.teamapps.cluster.dto.MessageUtils;

public class MessageField {
    private final int parentFieldId;
    private final int id;
    private final String name;
    private String title;
    private final MessageFieldType type;
    private final MessageFieldContentType contentType;
    private final String specificType;
    private final int referencedFieldId;
    private boolean deprecated;
    private String[] enumValues;
    private final List<MessageField> fields = new ArrayList<MessageField>();

    public MessageField(int parentFieldId, int id, String name, String title, MessageFieldType type, MessageFieldContentType contentType, String specificType, int referencedFieldId) {
        this.parentFieldId = parentFieldId;
        this.id = id;
        this.name = name;
        this.title = title;
        this.type = type;
        this.contentType = contentType;
        this.specificType = specificType;
        this.referencedFieldId = referencedFieldId;
    }

    public MessageField(DataInputStream dis) throws IOException {
        this.parentFieldId = dis.readInt();
        this.id = dis.readInt();
        this.name = MessageUtils.readString(dis);
        this.title = MessageUtils.readString(dis);
        this.type = MessageFieldType.getById(MessageUtils.readByteAsInt(dis));
        this.contentType = MessageFieldContentType.getById(MessageUtils.readByteAsInt(dis));
        this.specificType = MessageUtils.readString(dis);
        this.referencedFieldId = dis.readInt();
        this.deprecated = dis.readBoolean();
        int fieldCount = dis.readInt();
        for (int i = 0; i < fieldCount; ++i) {
            this.fields.add(new MessageField(dis));
        }
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.parentFieldId);
        dos.writeInt(this.id);
        MessageUtils.writeString(dos, this.name);
        MessageUtils.writeString(dos, this.title);
        MessageUtils.writeIntAsByte(dos, this.type.getId());
        MessageUtils.writeIntAsByte(dos, this.contentType.getId());
        MessageUtils.writeString(dos, this.specificType);
        dos.writeInt(this.referencedFieldId);
        dos.writeBoolean(this.deprecated);
        dos.writeInt(this.fields.size());
        for (MessageField field : this.fields) {
            field.write(dos);
        }
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos);
        dos.close();
        return bos.toByteArray();
    }

    public MessageField getById(int id) {
        if (this.id == id) {
            return this;
        }
        return this.fields.stream().filter(field -> field.getId() == id).findAny().orElse(null);
    }

    public MessageField getByName(String name) {
        if (this.name.equals(name)) {
            return this;
        }
        return this.fields.stream().filter(field -> field.getName().equals(name)).findAny().orElse(null);
    }

    public boolean isObject() {
        return this.type == MessageFieldType.OBJECT;
    }

    public boolean isObjectOrMultiReference() {
        return this.type == MessageFieldType.OBJECT || this.type == MessageFieldType.OBJECT_MULTI_REFERENCE;
    }

    public boolean isObjectReference() {
        return this.type == MessageFieldType.OBJECT_SINGLE_REFERENCE || this.type == MessageFieldType.OBJECT_MULTI_REFERENCE;
    }

    public boolean isSingleReference() {
        return this.type == MessageFieldType.OBJECT_SINGLE_REFERENCE;
    }

    public boolean isMultiReference() {
        return this.type == MessageFieldType.OBJECT_MULTI_REFERENCE;
    }

    protected void addField(MessageField field) {
        this.fields.add(field);
    }

    public int getParentFieldId() {
        return this.parentFieldId;
    }

    public MessageField getParent(MessageModel model) {
        return model.getFieldById(this.parentFieldId);
    }

    public int getReferencedFieldId() {
        return this.referencedFieldId;
    }

    public MessageField getReferencedField(MessageModel model) {
        return model.getFieldById(this.referencedFieldId);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public MessageField setTitle(String title) {
        this.title = title;
        return this;
    }

    public MessageFieldType getType() {
        return this.type;
    }

    public MessageFieldContentType getContentType() {
        return this.contentType;
    }

    public String getSpecificType() {
        return this.specificType;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public List<MessageField> getFields() {
        return this.fields;
    }

    protected String explain(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t".repeat(level)).append(this.name).append(", ").append(this.title).append(", ").append(this.id).append(", ").append((Object)this.type).append((String)(this.contentType != null ? ", " + this.contentType : "")).append("\n");
        this.getFields().forEach(field -> sb.append(field.explain(level + 1)));
        return sb.toString();
    }

    public String toString() {
        return this.explain(0);
    }
}

