package org.teamapps.cluster.protocol;

import org.teamapps.protocol.schema.*;
import org.teamapps.protocol.service.*;
import org.teamapps.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import io.netty.buffer.ByteBuf;
import java.util.*;


public class ClusterMethodExecution extends MessageObject {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<ClusterMethodExecution> decoder = new PojoObjectDecoder<ClusterMethodExecution>() {
		@Override
		public ClusterMethodExecution decode(DataInputStream dis, FileProvider fileProvider) {
			try {
				return new ClusterMethodExecution(dis, fileProvider);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterMethodExecution instance", e);
			}
			return null;
		}

		@Override
		public ClusterMethodExecution decode(ByteBuf buf, FileProvider fileProvider) {
			try {
				return new ClusterMethodExecution(buf, fileProvider);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterMethodExecution instance", e);
			}
			return null;
		}

		@Override
		public ClusterMethodExecution remap(MessageObject message) {
			return new ClusterMethodExecution(message, ClusterModel.MODEL_COLLECTION);
		}

        @Override
        public String getMessageObjectUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<ClusterMethodExecution> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ClusterModel.MODEL_COLLECTION;
	}

    public static ClusterMethodExecution remap(MessageObject message) {
        return new ClusterMethodExecution(message, ClusterModel.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "#tac.cme";


	public ClusterMethodExecution() {
		super(ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public ClusterMethodExecution(MessageObject message, PojoObjectDecoderRegistry pojoObjectDecoderRegistry) {
		super(message, pojoObjectDecoderRegistry);
	}

	public ClusterMethodExecution(DataInputStream dis) throws IOException {
		super(dis, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterModel.MODEL_COLLECTION);
	}

	public ClusterMethodExecution(DataInputStream dis, FileProvider fileProvider) throws IOException {
		super(dis, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, ClusterModel.MODEL_COLLECTION);
	}

	public ClusterMethodExecution(ByteBuf buf, FileProvider fileProvider) throws IOException {
		super(buf, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, ClusterModel.MODEL_COLLECTION);
	}

	public ClusterMethodExecution(byte[] bytes) throws IOException {
		super(bytes, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterModel.MODEL_COLLECTION);
	}

	public ClusterMethodExecution(byte[] bytes, FileProvider fileProvider) throws IOException {
		super(bytes, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, ClusterModel.MODEL_COLLECTION);
	}

	public boolean isResponse() {
		return getBooleanProperty("response");
	}

	public ClusterMethodExecution setResponse(boolean value) {
		setBooleanProperty("response", value);
		return this;
	}

	public long getRequestId() {
		return getLongProperty("requestId");
	}

	public ClusterMethodExecution setRequestId(long value) {
		setLongProperty("requestId", value);
		return this;
	}

	public String getServiceName() {
		return getStringProperty("serviceName");
	}

	public ClusterMethodExecution setServiceName(String value) {
		setStringProperty("serviceName", value);
		return this;
	}

	public String getServiceMethod() {
		return getStringProperty("serviceMethod");
	}

	public ClusterMethodExecution setServiceMethod(String value) {
		setStringProperty("serviceMethod", value);
		return this;
	}

	public byte[] getData() {
		return getByteArrayProperty("data");
	}

	public ClusterMethodExecution setData(byte[] value) {
		setByteArrayProperty("data", value);
		return this;
	}



}