/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.crypto;

import java.nio.ByteBuffer;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.teamapps.cluster.crypto.ShaHash;
import org.teamapps.cluster.utils.ExceptionUtil;

public class AesCipher {
    private Cipher cipher;
    private SecretKeySpec secretKeySpec;
    private SecureRandom secureRandom = new SecureRandom();
    private static int BLOCK_SIZE_BYTES = 16;

    public AesCipher(String key) {
        this(ShaHash.createHashBytes(key));
    }

    public AesCipher(byte[] key) {
        this.secretKeySpec = new SecretKeySpec(key, "AES");
        try {
            this.cipher = Cipher.getInstance("AES/CTR/NoPadding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
    }

    public synchronized byte[] encrypt(byte[] data) throws Exception {
        byte[] iv = new byte[BLOCK_SIZE_BYTES];
        this.secureRandom.nextBytes(iv);
        this.cipher.init(1, (Key)this.secretKeySpec, new IvParameterSpec(iv));
        return AesCipher.combineArrays(iv, this.cipher.doFinal(data));
    }

    public byte[] encryptSave(byte[] data) {
        return ExceptionUtil.softenExceptions(() -> this.encrypt(data));
    }

    public byte[] decrypt(byte[] data) throws Exception {
        return this.decrypt(data, 0);
    }

    public byte[] decryptSave(byte[] data) {
        return ExceptionUtil.softenExceptions(() -> this.decrypt(data, 0));
    }

    public synchronized byte[] decrypt(byte[] data, int offset) throws Exception {
        byte[] iv = new byte[BLOCK_SIZE_BYTES];
        System.arraycopy(data, offset, iv, 0, BLOCK_SIZE_BYTES);
        this.cipher.init(2, (Key)this.secretKeySpec, new IvParameterSpec(iv));
        return this.cipher.doFinal(data, BLOCK_SIZE_BYTES + offset, data.length - (BLOCK_SIZE_BYTES + offset));
    }

    public synchronized byte[] encrypt(long nonce, long id, byte[] data) throws Exception {
        byte[] iv = new byte[BLOCK_SIZE_BYTES];
        ByteBuffer buffer = ByteBuffer.wrap(iv);
        buffer.putLong(nonce);
        buffer.putLong(id);
        this.cipher.init(1, (Key)this.secretKeySpec, new IvParameterSpec(iv));
        return this.cipher.doFinal(data);
    }

    public synchronized byte[] decrypt(long nonce, long id, byte[] data) throws Exception {
        byte[] iv = new byte[BLOCK_SIZE_BYTES];
        ByteBuffer buffer = ByteBuffer.wrap(iv);
        buffer.putLong(nonce);
        buffer.putLong(id);
        this.cipher.init(2, (Key)this.secretKeySpec, new IvParameterSpec(iv));
        return this.cipher.doFinal(data);
    }

    public int encryptInt(long nonce, long id, int value) throws Exception {
        return this.cryptInt(nonce, id, value, 1);
    }

    public int decryptInt(long nonce, long id, int value) throws Exception {
        return this.cryptInt(nonce, id, value, 2);
    }

    private synchronized int cryptInt(long nonce, long id, int value, int encryptMode) throws Exception {
        byte[] iv = new byte[BLOCK_SIZE_BYTES];
        ByteBuffer ivBuf = ByteBuffer.wrap(iv);
        ivBuf.putLong(nonce);
        ivBuf.putLong(id);
        byte[] data = new byte[4];
        ByteBuffer buf = ByteBuffer.wrap(data);
        buf.putInt(0, value);
        this.cipher.init(encryptMode, (Key)this.secretKeySpec, new IvParameterSpec(iv));
        byte[] bytes = this.cipher.doFinal(data);
        buf = ByteBuffer.wrap(bytes);
        return buf.getInt(0);
    }

    public static byte[] combineArrays(byte[] array1, byte[] array2) {
        byte[] joinedArray = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }
}

