package org.teamapps.cluster.protocol;

import org.teamapps.protocol.schema.*;
import org.teamapps.protocol.service.*;
import org.teamapps.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import io.netty.buffer.ByteBuf;
import java.util.*;


public class ClusterInfo extends MessageObject {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<ClusterInfo> decoder = new PojoObjectDecoder<ClusterInfo>() {
		@Override
		public ClusterInfo decode(DataInputStream dis, FileProvider fileProvider) {
			try {
				return new ClusterInfo(dis, fileProvider);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterInfo instance", e);
			}
			return null;
		}

		@Override
		public ClusterInfo decode(ByteBuf buf, FileProvider fileProvider) {
			try {
				return new ClusterInfo(buf, fileProvider);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterInfo instance", e);
			}
			return null;
		}

		@Override
		public ClusterInfo remap(MessageObject message) {
			return new ClusterInfo(message, ClusterModel.MODEL_COLLECTION);
		}

        @Override
        public String getMessageObjectUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<ClusterInfo> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ClusterModel.MODEL_COLLECTION;
	}

    public static ClusterInfo remap(MessageObject message) {
        return new ClusterInfo(message, ClusterModel.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "#tac.ci";


	public ClusterInfo() {
		super(ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public ClusterInfo(MessageObject message, PojoObjectDecoderRegistry pojoObjectDecoderRegistry) {
		super(message, pojoObjectDecoderRegistry);
	}

	public ClusterInfo(DataInputStream dis) throws IOException {
		super(dis, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterModel.MODEL_COLLECTION);
	}

	public ClusterInfo(DataInputStream dis, FileProvider fileProvider) throws IOException {
		super(dis, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, ClusterModel.MODEL_COLLECTION);
	}

	public ClusterInfo(ByteBuf buf, FileProvider fileProvider) throws IOException {
		super(buf, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, ClusterModel.MODEL_COLLECTION);
	}

	public ClusterInfo(byte[] bytes) throws IOException {
		super(bytes, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterModel.MODEL_COLLECTION);
	}

	public ClusterInfo(byte[] bytes, FileProvider fileProvider) throws IOException {
		super(bytes, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, ClusterModel.MODEL_COLLECTION);
	}

	public boolean isInitialMessage() {
		return getBooleanProperty("initialMessage");
	}

	public ClusterInfo setInitialMessage(boolean value) {
		setBooleanProperty("initialMessage", value);
		return this;
	}

	public boolean isResponse() {
		return getBooleanProperty("response");
	}

	public ClusterInfo setResponse(boolean value) {
		setBooleanProperty("response", value);
		return this;
	}

	public NodeInfo getLocalNode() {
		return getReferencedObjectAsType("localNode");
	}

	public ClusterInfo setLocalNode(NodeInfo value) {
		setReferencedObjectAsType("localNode", value);
		return this;
	}

	public List<NodeInfo> getRemoteNodes() {
		return getReferencedObjectsAsType("remoteNodes");
	}

	public ClusterInfo setRemoteNodes(List<NodeInfo> value) {
		setReferencedObjectsAsType("remoteNodes", value);
		return this;
	}

	public ClusterInfo addRemoteNodes(NodeInfo value) {
		addReference("remoteNodes", value);
		return this;
	}



}