package org.teamapps.cluster.protocol;

import org.teamapps.protocol.schema.*;
import org.teamapps.protocol.service.*;
import org.teamapps.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import io.netty.buffer.ByteBuf;
import java.util.*;


public class NodeInfo extends MessageObject {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<NodeInfo> decoder = new PojoObjectDecoder<NodeInfo>() {
		@Override
		public NodeInfo decode(DataInputStream dis, FileProvider fileProvider) {
			try {
				return new NodeInfo(dis, fileProvider);
			} catch (IOException e) {
				LOGGER.error("Error creating NodeInfo instance", e);
			}
			return null;
		}

		@Override
		public NodeInfo decode(ByteBuf buf, FileProvider fileProvider) {
			try {
				return new NodeInfo(buf, fileProvider);
			} catch (IOException e) {
				LOGGER.error("Error creating NodeInfo instance", e);
			}
			return null;
		}

		@Override
		public NodeInfo remap(MessageObject message) {
			return new NodeInfo(message, ClusterModel.MODEL_COLLECTION);
		}

        @Override
        public String getMessageObjectUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<NodeInfo> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ClusterModel.MODEL_COLLECTION;
	}

    public static NodeInfo remap(MessageObject message) {
        return new NodeInfo(message, ClusterModel.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "#tac.ni";


	public NodeInfo() {
		super(ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public NodeInfo(MessageObject message, PojoObjectDecoderRegistry pojoObjectDecoderRegistry) {
		super(message, pojoObjectDecoderRegistry);
	}

	public NodeInfo(DataInputStream dis) throws IOException {
		super(dis, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterModel.MODEL_COLLECTION);
	}

	public NodeInfo(DataInputStream dis, FileProvider fileProvider) throws IOException {
		super(dis, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, ClusterModel.MODEL_COLLECTION);
	}

	public NodeInfo(ByteBuf buf, FileProvider fileProvider) throws IOException {
		super(buf, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, ClusterModel.MODEL_COLLECTION);
	}

	public NodeInfo(byte[] bytes) throws IOException {
		super(bytes, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterModel.MODEL_COLLECTION);
	}

	public NodeInfo(byte[] bytes, FileProvider fileProvider) throws IOException {
		super(bytes, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, ClusterModel.MODEL_COLLECTION);
	}

	public String getNodeId() {
		return getStringProperty("nodeId");
	}

	public NodeInfo setNodeId(String value) {
		setStringProperty("nodeId", value);
		return this;
	}

	public boolean isLeader() {
		return getBooleanProperty("leader");
	}

	public NodeInfo setLeader(boolean value) {
		setBooleanProperty("leader", value);
		return this;
	}

	public String getHost() {
		return getStringProperty("host");
	}

	public NodeInfo setHost(String value) {
		setStringProperty("host", value);
		return this;
	}

	public int getPort() {
		return getIntProperty("port");
	}

	public NodeInfo setPort(int value) {
		setIntProperty("port", value);
		return this;
	}

	public boolean isReachable() {
		return getBooleanProperty("reachable");
	}

	public NodeInfo setReachable(boolean value) {
		setBooleanProperty("reachable", value);
		return this;
	}

	public String[] getServices() {
		return getStringArrayProperty("services");
	}

	public NodeInfo setServices(String[] value) {
		setStringArrayProperty("services", value);
		return this;
	}



}