/*-
 * ========================LICENSE_START=================================
 * TeamApps Cluster
 * ---
 * Copyright (C) 2021 - 2022 TeamApps.org
 * ---
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
package org.teamapps.cluster.state;

public class ReplicatedStateTransactionRule {

	private final String subStateId;
	private final String identifier;
	private final TransactionCompareRule compareRule;
	private final int value;


	private ReplicatedStateTransactionRule(String subStateId, String identifier, TransactionCompareRule compareRule, int value) {
		this.subStateId = subStateId;
		this.identifier = identifier;
		this.compareRule = compareRule;
		this.value = value;
	}


	public String getSubStateId() {
		return subStateId;
	}

	public String getIdentifier() {
		return identifier;
	}

	public TransactionCompareRule getCompareRule() {
		return compareRule;
	}

	public int getValue() {
		return value;
	}
}
