/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.core;

import java.io.IOException;
import java.util.List;
import org.teamapps.cluster.core.ClusterImpl;
import org.teamapps.cluster.core.HostAddress;
import org.teamapps.cluster.core.LocalNode;
import org.teamapps.cluster.core.MessageHandler;
import org.teamapps.cluster.core.RemoteNode;
import org.teamapps.protocol.schema.ClusterServiceRegistry;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.ModelCollection;
import org.teamapps.protocol.schema.PojoObjectDecoder;

public interface Cluster
extends ClusterServiceRegistry {
    public static Cluster createCluster(String clusterSecret, String nodeId, HostAddress ... knownNodes) {
        try {
            return new ClusterImpl(clusterSecret, nodeId, false, knownNodes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Cluster createCluster(String clusterSecret, String nodeId, HostAddress externalAddress, boolean leader, HostAddress ... knownNodes) {
        try {
            return new ClusterImpl(clusterSecret, nodeId, externalAddress, externalAddress, leader, knownNodes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Cluster createCluster(String clusterSecret, String nodeId, HostAddress externalAddress, HostAddress bindToAddress, boolean leader, HostAddress ... knownNodes) {
        try {
            return new ClusterImpl(clusterSecret, nodeId, externalAddress, bindToAddress, leader, knownNodes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addModelCollection(ModelCollection var1);

    public LocalNode getLocalNode();

    public List<RemoteNode> getRemoteNodes();

    public void addRemoteNode(RemoteNode var1);

    public RemoteNode getRemoteNode(String var1);

    public boolean isServiceAvailable(String var1);

    public <MESSAGE extends MessageObject> void sendMessage(MESSAGE var1, String var2);

    public <MESSAGE extends MessageObject> void sendTopicMessage(String var1, MESSAGE var2);

    public <MESSAGE extends MessageObject> void registerMessageHandler(MessageHandler<MESSAGE> var1, PojoObjectDecoder<MESSAGE> var2);

    public <MESSAGE extends MessageObject> void registerTopicHandler(String var1, MessageHandler<MESSAGE> var2, PojoObjectDecoder<MESSAGE> var3);

    public void shutDown();
}

