/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.core;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.teamapps.cluster.core.MessageQueueEntry;
import org.teamapps.protocol.schema.MessageObject;

public class MessageQueue {
    private ArrayBlockingQueue<MessageQueueEntry> messageQueue = new ArrayBlockingQueue(100000);
    private MessageQueueEntry lastEntry;

    public void reuseQueue(MessageQueue queue) {
        List<MessageQueueEntry> entries = queue.getEntries(false);
        if (this.messageQueue.remainingCapacity() > entries.size()) {
            entries.forEach(e -> this.messageQueue.offer((MessageQueueEntry)e));
        }
    }

    public boolean addMessage(MessageQueueEntry entry) {
        return this.messageQueue.offer(entry);
    }

    public boolean addMessage(MessageObject message, boolean resendOnError) {
        MessageQueueEntry queueEntry = new MessageQueueEntry(resendOnError, message);
        return this.messageQueue.offer(queueEntry);
    }

    public MessageQueueEntry getNext() {
        if (this.lastEntry != null) {
            return this.lastEntry;
        }
        while (true) {
            try {
                do {
                    this.lastEntry = this.messageQueue.poll(1000L, TimeUnit.MILLISECONDS);
                } while (this.lastEntry == null);
                return this.lastEntry;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void commitLastMessage() {
        this.lastEntry = null;
    }

    public void recycleQueue() {
        if (this.lastEntry != null && !this.lastEntry.isResendOnError()) {
            this.lastEntry = null;
        }
        this.messageQueue.removeIf(entry -> !entry.isResendOnError());
    }

    public List<MessageQueueEntry> getEntries(boolean includeAll) {
        return this.messageQueue.stream().filter(e -> e.isResendOnError() || includeAll).collect(Collectors.toList());
    }
}

