/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.core;

import org.teamapps.protocol.schema.MessageObject;

public class MessageQueueEntry {
    private final long timestamp = System.currentTimeMillis();
    private final boolean resendOnError;
    private final boolean serviceExecution;
    private final MessageObject message;
    private String serviceName;
    private String serviceMethod;
    private long requestId;
    private boolean serviceResponse;

    public MessageQueueEntry(boolean resendOnError, MessageObject message) {
        this.resendOnError = resendOnError;
        this.serviceExecution = false;
        this.message = message;
    }

    public MessageQueueEntry(boolean resendOnError, boolean serviceExecution, MessageObject message, String serviceName, String serviceMethod, boolean serviceResponse, long requestId) {
        this.resendOnError = resendOnError;
        this.serviceExecution = serviceExecution;
        this.message = message;
        this.serviceName = serviceName;
        this.serviceMethod = serviceMethod;
        this.serviceResponse = serviceResponse;
        this.requestId = requestId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isResendOnError() {
        return this.resendOnError;
    }

    public MessageObject getMessage() {
        return this.message;
    }

    public boolean isServiceExecution() {
        return this.serviceExecution;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceMethod() {
        return this.serviceMethod;
    }

    public boolean isServiceResponse() {
        return this.serviceResponse;
    }

    public long getRequestId() {
        return this.requestId;
    }
}

