/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.crypto;

import java.nio.ByteBuffer;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.teamapps.cluster.crypto.ShaHash;

public class AesRaBlockCipher {
    private static int BLOCK_SIZE_BYTES = 16;
    private final Cipher cipher;
    private final SecretKey secretKeySpec;
    private final SecureRandom secureRandom;
    private final int ctrOffset;
    private final byte[] ivData;
    private final ByteBuffer ivBuffer;

    public AesRaBlockCipher(String key) throws Exception {
        this(ShaHash.createHashBytes(key), null, 0);
    }

    public AesRaBlockCipher(String key, String ivAsHex) throws Exception {
        this(ShaHash.createHashBytes(key), ivAsHex != null ? Hex.decodeHex((String)ivAsHex) : null, 0);
    }

    public AesRaBlockCipher(String key, String ivAsHex, int ctrOffset) throws Exception {
        this(ShaHash.createHashBytes(key), ivAsHex != null ? Hex.decodeHex((String)ivAsHex) : null, ctrOffset);
    }

    public AesRaBlockCipher(byte[] key, byte[] ivData, int ctrOffset) throws Exception {
        this.ctrOffset = ctrOffset;
        this.secureRandom = new SecureRandom();
        this.secretKeySpec = new SecretKeySpec(key, "AES");
        this.cipher = Cipher.getInstance("AES/CTR/NoPadding");
        if (ivData == null) {
            ivData = new byte[BLOCK_SIZE_BYTES];
            this.secureRandom.nextBytes(ivData);
        }
        this.ivBuffer = ByteBuffer.wrap(ivData);
        this.ivData = ivData;
    }

    private void initCypher(int pos, int dataLength, boolean encrypt) throws Exception {
        int counter = AesRaBlockCipher.getCounter(pos, dataLength);
        this.ivBuffer.putInt(12, this.ctrOffset + counter);
        this.cipher.init(encrypt ? 1 : 2, (Key)this.secretKeySpec, new IvParameterSpec(this.ivData));
    }

    private static int getCounter(int pos, int dataLength) {
        return pos / (BLOCK_SIZE_BYTES / dataLength);
    }

    private static int getBlockPos(int pos, int dataLength) {
        return pos % (BLOCK_SIZE_BYTES / dataLength);
    }

    public synchronized byte[] encryptInteger(int pos, int value, byte[] blockData) throws Exception {
        int dataLength = 4;
        boolean emptyBlock = Arrays.equals(blockData, new byte[blockData.length]);
        byte[] block = blockData;
        if (!emptyBlock) {
            this.initCypher(pos, dataLength, false);
            block = this.cipher.doFinal(blockData);
        }
        ByteBuffer buffer = ByteBuffer.wrap(block);
        int blockPos = AesRaBlockCipher.getBlockPos(pos, dataLength);
        buffer.putInt(blockPos * dataLength, value);
        this.initCypher(pos, dataLength, true);
        return this.cipher.doFinal(block);
    }

    public synchronized int decryptInteger(int pos, byte[] blockData) throws Exception {
        int dataLength = 4;
        boolean emptyBlock = Arrays.equals(blockData, new byte[blockData.length]);
        if (emptyBlock) {
            return 0;
        }
        this.initCypher(pos, dataLength, false);
        int blockPos = AesRaBlockCipher.getBlockPos(pos, dataLength);
        byte[] bytes = this.cipher.doFinal(blockData);
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        return buf.getInt(blockPos * dataLength);
    }

    public static byte[] getBlockData(int pos, int dataLength, byte[] data) {
        int counter = AesRaBlockCipher.getCounter(pos, dataLength);
        int offset = counter * BLOCK_SIZE_BYTES;
        return Arrays.copyOfRange(data, offset, offset + BLOCK_SIZE_BYTES);
    }

    private static void mergeBlockData(int pos, int dataLength, byte[] data, byte[] blockData) {
        int counter = AesRaBlockCipher.getCounter(pos, dataLength);
        int offset = counter * BLOCK_SIZE_BYTES;
        System.arraycopy(blockData, 0, data, offset, blockData.length);
    }

    public static void main(String[] args) throws Exception {
        int i;
        byte[] data = new byte[40000000];
        AesRaBlockCipher cipher = new AesRaBlockCipher("the key");
        long time = System.currentTimeMillis();
        for (i = 0; i < 10000000; ++i) {
            byte[] blockData = AesRaBlockCipher.getBlockData(i, 4, data);
            byte[] encryptedBlockData = cipher.encryptInteger(i, i, blockData);
            AesRaBlockCipher.mergeBlockData(i, 4, data, encryptedBlockData);
        }
        System.out.println("TIME ENC:" + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        for (i = 0; i < 10000000; ++i) {
            int n = cipher.decryptInteger(i, AesRaBlockCipher.getBlockData(i, 4, data));
        }
        System.out.println("TIME DEC:" + (System.currentTimeMillis() - time));
    }
}

