/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.protocol;

import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.cluster.protocol.ClusterModel;
import org.teamapps.protocol.file.FileProvider;
import org.teamapps.protocol.schema.MessageModel;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.ModelCollection;
import org.teamapps.protocol.schema.PojoObjectDecoder;
import org.teamapps.protocol.schema.PojoObjectDecoderRegistry;

public class ClusterMethodExecution
extends MessageObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PojoObjectDecoder<ClusterMethodExecution> decoder = new PojoObjectDecoder<ClusterMethodExecution>(){

        public ClusterMethodExecution decode(DataInputStream dis, FileProvider fileProvider) {
            try {
                return new ClusterMethodExecution(dis, fileProvider);
            }
            catch (IOException e) {
                LOGGER.error("Error creating ClusterMethodExecution instance", (Throwable)e);
                return null;
            }
        }

        public ClusterMethodExecution decode(ByteBuf buf, FileProvider fileProvider) {
            try {
                return new ClusterMethodExecution(buf, fileProvider);
            }
            catch (IOException e) {
                LOGGER.error("Error creating ClusterMethodExecution instance", (Throwable)e);
                return null;
            }
        }

        public ClusterMethodExecution remap(MessageObject message) {
            return new ClusterMethodExecution(message, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
        }

        public String getMessageObjectUuid() {
            return ClusterMethodExecution.OBJECT_UUID;
        }
    };
    public static final String OBJECT_UUID = "#tac.cme";

    public static PojoObjectDecoder<ClusterMethodExecution> getMessageDecoder() {
        return decoder;
    }

    public static MessageModel getMessageModel() {
        return ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

    public static ModelCollection getModelCollection() {
        return ClusterModel.MODEL_COLLECTION;
    }

    public static ClusterMethodExecution remap(MessageObject message) {
        return new ClusterMethodExecution(message, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
    }

    public ClusterMethodExecution() {
        super(ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID));
    }

    public ClusterMethodExecution(MessageObject message, PojoObjectDecoderRegistry pojoObjectDecoderRegistry) {
        super(message, pojoObjectDecoderRegistry);
    }

    public ClusterMethodExecution(DataInputStream dis) throws IOException {
        super(dis, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), null, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
    }

    public ClusterMethodExecution(DataInputStream dis, FileProvider fileProvider) throws IOException {
        super(dis, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
    }

    public ClusterMethodExecution(ByteBuf buf, FileProvider fileProvider) throws IOException {
        super(buf, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
    }

    public ClusterMethodExecution(byte[] bytes) throws IOException {
        super(bytes, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), null, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
    }

    public ClusterMethodExecution(byte[] bytes, FileProvider fileProvider) throws IOException {
        super(bytes, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
    }

    public boolean isResponse() {
        return this.getBooleanProperty("response");
    }

    public ClusterMethodExecution setResponse(boolean value) {
        this.setBooleanProperty("response", value);
        return this;
    }

    public long getRequestId() {
        return this.getLongProperty("requestId");
    }

    public ClusterMethodExecution setRequestId(long value) {
        this.setLongProperty("requestId", value);
        return this;
    }

    public String getServiceName() {
        return this.getStringProperty("serviceName");
    }

    public ClusterMethodExecution setServiceName(String value) {
        this.setStringProperty("serviceName", value);
        return this;
    }

    public String getServiceMethod() {
        return this.getStringProperty("serviceMethod");
    }

    public ClusterMethodExecution setServiceMethod(String value) {
        this.setStringProperty("serviceMethod", value);
        return this;
    }

    public byte[] getData() {
        return this.getByteArrayProperty("data");
    }

    public ClusterMethodExecution setData(byte[] value) {
        this.setByteArrayProperty("data", value);
        return this;
    }
}

