/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.state;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.teamapps.cluster.state.ChangeOperation;
import org.teamapps.cluster.state.ReplicatedState;
import org.teamapps.cluster.state.ReplicatedStateHandler;
import org.teamapps.cluster.state.ReplicatedStateTransactionRule;
import org.teamapps.cluster.state.StateUpdate;
import org.teamapps.cluster.state.StateUpdateMessage;
import org.teamapps.protocol.schema.MessageObject;

public abstract class AbstractReplicatedState
implements ReplicatedState {
    private final String name;
    private final ReplicatedStateHandler handler;
    private Map<String, List<MessageObject>> messageMap = new ConcurrentHashMap<String, List<MessageObject>>();
    private Map<String, Map<String, MessageObject>> messageById = new ConcurrentHashMap<String, Map<String, MessageObject>>();
    private Map<String, MessageObject> propertyById = new ConcurrentHashMap<String, MessageObject>();

    public AbstractReplicatedState(String name, ReplicatedStateHandler handler) {
        this.name = name;
        this.handler = handler;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void handleStateMachineUpdate(StateUpdate update) {
        List<ReplicatedStateTransactionRule> transactionConditions = update.getTransactionConditions();
        if (transactionConditions != null) {
            for (ReplicatedStateTransactionRule condition : transactionConditions) {
                String subStateId = condition.getSubStateId();
                switch (condition.getCompareRule()) {
                    case CONTAINS: {
                        if (this.getEntry(subStateId, condition.getIdentifier()) != null) break;
                        return;
                    }
                    case CONTAINS_NOT: {
                        if (this.getEntry(subStateId, condition.getIdentifier()) == null) break;
                        return;
                    }
                    case LIST_SIZE_EQUALS: {
                        if (condition.getValue() == this.getEntryCount(subStateId)) break;
                        return;
                    }
                    case LIST_SIZE_GREATER: {
                        if (condition.getValue() > this.getEntryCount(subStateId)) break;
                        return;
                    }
                    case LIST_SIZE_SMALLER: {
                        if (condition.getValue() < this.getEntryCount(subStateId)) break;
                        return;
                    }
                }
            }
        }
        for (StateUpdateMessage stateUpdateMessage : update.getUpdateMessages()) {
            this.handleUpdate(stateUpdateMessage);
        }
    }

    private void handleUpdate(StateUpdateMessage stateUpdateMessage) {
        ChangeOperation operation = stateUpdateMessage.getOperation();
        MessageObject message = stateUpdateMessage.getMessage();
        String subStateId = stateUpdateMessage.getSubStateId();
        String identifier = stateUpdateMessage.getIdentifier();
        switch (operation) {
            case ADD: {
                this.messageMap.computeIfAbsent(subStateId, s -> new ArrayList()).add(message);
                this.messageById.computeIfAbsent(subStateId, s -> new ConcurrentHashMap()).put(identifier, message);
                this.handler.handleEntryAdded(subStateId, message);
                break;
            }
            case UPDATE: {
                MessageObject previousEntry = (MessageObject)this.messageById.computeIfAbsent(subStateId, s -> new ConcurrentHashMap()).remove(identifier);
                if (previousEntry != null) {
                    this.messageById.get(subStateId).put(identifier, message);
                    this.messageMap.computeIfAbsent(subStateId, s -> new ArrayList()).remove(previousEntry);
                    this.messageMap.computeIfAbsent(subStateId, s -> new ArrayList()).add(message);
                    this.handler.handleEntryUpdated(subStateId, message, previousEntry);
                    break;
                }
                this.messageById.get(subStateId).put(identifier, message);
                this.messageMap.computeIfAbsent(subStateId, s -> new ArrayList()).add(message);
                break;
            }
            case REMOVE: {
                MessageObject messageObject = (MessageObject)this.messageById.computeIfAbsent(subStateId, s -> new ConcurrentHashMap()).remove(identifier);
                if (messageObject == null) break;
                this.messageMap.get(subStateId).remove(messageObject);
                this.handler.handleEntryRemoved(subStateId, messageObject);
                break;
            }
            case SET: {
                this.propertyById.put(subStateId, message);
                this.handler.handleStateUpdated(subStateId, message);
                break;
            }
            case REMOVE_ALL: {
                this.messageById.put(subStateId, new ConcurrentHashMap());
                this.messageMap.put(subStateId, new ArrayList());
                this.handler.handleAllEntriesRemoved(subStateId);
                break;
            }
            case SEND_AND_FORGET: {
                this.handler.handleFireAndForget(subStateId, message);
            }
        }
    }

    private void sendStateMachineUpdate(StateUpdateMessage stateUpdateMessage) {
        this.sendStateMachineUpdate(new StateUpdate(this.name, stateUpdateMessage));
    }

    public abstract void sendStateMachineUpdate(StateUpdate var1);

    @Override
    public MessageObject getEntry(String list, String identifier) {
        return (MessageObject)this.messageById.computeIfAbsent(list, s -> new ConcurrentHashMap()).get(identifier);
    }

    @Override
    public List<MessageObject> getEntries(String list) {
        return this.messageMap.get(list);
    }

    @Override
    public int getEntryCount(String list) {
        List<MessageObject> entries = this.getEntries(list);
        return entries != null ? entries.size() : 0;
    }

    @Override
    public List<String> getLists() {
        return new ArrayList<String>(this.messageMap.keySet());
    }

    @Override
    public MessageObject getProperty(String stateId) {
        return this.propertyById.get(stateId);
    }

    @Override
    public StateUpdateMessage prepareAddEntry(String list, String identifier, MessageObject message) {
        return new StateUpdateMessage(list, ChangeOperation.ADD, identifier, message);
    }

    @Override
    public StateUpdateMessage prepareRemoveEntry(String list, String identifier) {
        return new StateUpdateMessage(list, ChangeOperation.REMOVE, identifier, null);
    }

    @Override
    public StateUpdateMessage prepareUpdateEntry(String list, String identifier, MessageObject message) {
        return new StateUpdateMessage(list, ChangeOperation.UPDATE, identifier, message);
    }

    @Override
    public StateUpdateMessage prepareRemoveAllEntries(String list) {
        return new StateUpdateMessage(list, ChangeOperation.REMOVE_ALL, null, null);
    }

    @Override
    public StateUpdateMessage prepareSetState(String stateId, MessageObject message) {
        return new StateUpdateMessage(stateId, ChangeOperation.SET, null, message);
    }

    @Override
    public StateUpdateMessage prepareFireAndForget(String messageType, MessageObject message) {
        return new StateUpdateMessage(messageType, ChangeOperation.SEND_AND_FORGET, null, message);
    }

    @Override
    public void executeStateMachineUpdate(StateUpdateMessage ... updates) {
        this.sendStateMachineUpdate(new StateUpdate(this.name, Arrays.asList(updates)));
    }

    @Override
    public void executeStateMachineUpdate(StateUpdate update) {
        this.sendStateMachineUpdate(update);
    }

    @Override
    public void addEntry(String list, String identifier, MessageObject message) {
        this.executeStateMachineUpdate(this.prepareAddEntry(list, identifier, message));
    }

    @Override
    public void removeEntry(String list, String identifier) {
        this.executeStateMachineUpdate(this.prepareRemoveEntry(list, identifier));
    }

    @Override
    public void updateEntry(String list, String identifier, MessageObject message) {
        this.executeStateMachineUpdate(this.prepareUpdateEntry(list, identifier, message));
    }

    @Override
    public void removeAllEntries(String list) {
        this.executeStateMachineUpdate(this.prepareRemoveAllEntries(list));
    }

    @Override
    public void setProperty(String stateId, MessageObject message) {
        this.executeStateMachineUpdate(this.prepareSetState(stateId, message));
    }

    @Override
    public void fireAndForget(String messageType, MessageObject message) {
        this.executeStateMachineUpdate(this.prepareFireAndForget(messageType, message));
    }
}

