/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.state;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teamapps.cluster.state.ReplicatedStateTransactionRule;
import org.teamapps.cluster.state.StateUpdateMessage;
import org.teamapps.protocol.file.FileProvider;
import org.teamapps.protocol.file.FileSink;
import org.teamapps.protocol.message.MessageUtils;
import org.teamapps.protocol.schema.ModelRegistry;

public class StateUpdate {
    private final String stateMachine;
    private long updateId;
    private final List<StateUpdateMessage> stateUpdateMessages;
    private final List<ReplicatedStateTransactionRule> transactionConditions;

    public StateUpdate(String stateMachine, StateUpdateMessage stateUpdateMessage) {
        this.stateMachine = stateMachine;
        this.updateId = this.updateId;
        this.stateUpdateMessages = Collections.singletonList(stateUpdateMessage);
        this.transactionConditions = null;
    }

    public StateUpdate(String stateMachine, List<StateUpdateMessage> stateUpdateMessages) {
        this.stateMachine = stateMachine;
        this.updateId = this.updateId;
        this.stateUpdateMessages = stateUpdateMessages;
        this.transactionConditions = null;
    }

    public StateUpdate(DataInputStream dis, ModelRegistry modelRegistry, FileProvider fileProvider) throws IOException {
        this.stateMachine = MessageUtils.readString((DataInputStream)dis);
        this.updateId = dis.readLong();
        int size = dis.readInt();
        this.stateUpdateMessages = new ArrayList<StateUpdateMessage>();
        for (int i = 0; i < size; ++i) {
            this.stateUpdateMessages.add(new StateUpdateMessage(dis, modelRegistry, fileProvider));
        }
        int rules = dis.readInt();
        if (rules > 0) {
            this.transactionConditions = new ArrayList<ReplicatedStateTransactionRule>();
            for (int i = 0; i < rules; ++i) {
            }
        } else {
            this.transactionConditions = null;
        }
    }

    public List<StateUpdateMessage> getUpdateMessages() {
        return this.stateUpdateMessages;
    }

    public List<ReplicatedStateTransactionRule> getTransactionConditions() {
        return this.transactionConditions;
    }

    public long getUpdateId() {
        return this.updateId;
    }

    public void setUpdateId(long updateId) {
        this.updateId = updateId;
    }

    public String getStateMachine() {
        return this.stateMachine;
    }

    public void write(DataOutputStream dos, FileSink fileSink) throws IOException {
        MessageUtils.writeString((DataOutputStream)dos, (String)this.stateMachine);
        dos.writeLong(this.updateId);
        dos.writeInt(this.stateUpdateMessages.size());
        for (StateUpdateMessage stateUpdateMessage : this.stateUpdateMessages) {
            stateUpdateMessage.write(dos, fileSink);
        }
        if (this.transactionConditions == null || this.transactionConditions.isEmpty()) {
            dos.writeInt(0);
        } else {
            dos.writeInt(this.transactionConditions.size());
        }
    }

    public byte[] toBytes(FileSink fileSink) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos, fileSink);
        dos.flush();
        return bos.toByteArray();
    }
}

