package org.teamapps.cluster.protocol;

import org.teamapps.protocol.schema.*;
import org.teamapps.protocol.service.*;
import org.teamapps.protocol.file.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.lang.invoke.MethodHandles;
import java.io.*;
import java.nio.ByteBuffer;
import io.netty.buffer.ByteBuf;
import java.util.*;


public class ClusterMessageFilePart extends MessageObject {
	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private final static PojoObjectDecoder<ClusterMessageFilePart> decoder = new PojoObjectDecoder<ClusterMessageFilePart>() {
		@Override
		public ClusterMessageFilePart decode(DataInputStream dis, FileProvider fileProvider) {
			try {
				return new ClusterMessageFilePart(dis, fileProvider);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterMessageFilePart instance", e);
			}
			return null;
		}

		@Override
		public ClusterMessageFilePart decode(ByteBuf buf, FileProvider fileProvider) {
			try {
				return new ClusterMessageFilePart(buf, fileProvider);
			} catch (IOException e) {
				LOGGER.error("Error creating ClusterMessageFilePart instance", e);
			}
			return null;
		}

		@Override
		public ClusterMessageFilePart remap(MessageObject message) {
			return new ClusterMessageFilePart(message, ClusterModel.MODEL_COLLECTION);
		}

        @Override
        public String getMessageObjectUuid() {
            return OBJECT_UUID;
        }
	};

	public static PojoObjectDecoder<ClusterMessageFilePart> getMessageDecoder() {
		return decoder;
	}

	public static MessageModel getMessageModel() {
        return ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

	public static ModelCollection getModelCollection() {
		return ClusterModel.MODEL_COLLECTION;
	}

    public static ClusterMessageFilePart remap(MessageObject message) {
        return new ClusterMessageFilePart(message, ClusterModel.MODEL_COLLECTION);
    }

    public final static String OBJECT_UUID = "#tac.cmfp";


	public ClusterMessageFilePart() {
		super(ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID));
	}

	public ClusterMessageFilePart(MessageObject message, PojoObjectDecoderRegistry pojoObjectDecoderRegistry) {
		super(message, pojoObjectDecoderRegistry);
	}

	public ClusterMessageFilePart(DataInputStream dis) throws IOException {
		super(dis, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterModel.MODEL_COLLECTION);
	}

	public ClusterMessageFilePart(DataInputStream dis, FileProvider fileProvider) throws IOException {
		super(dis, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, ClusterModel.MODEL_COLLECTION);
	}

	public ClusterMessageFilePart(ByteBuf buf, FileProvider fileProvider) throws IOException {
		super(buf, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, ClusterModel.MODEL_COLLECTION);
	}

	public ClusterMessageFilePart(byte[] bytes) throws IOException {
		super(bytes, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), null, ClusterModel.MODEL_COLLECTION);
	}

	public ClusterMessageFilePart(byte[] bytes, FileProvider fileProvider) throws IOException {
		super(bytes, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, ClusterModel.MODEL_COLLECTION);
	}

	public String getFileId() {
		return getStringProperty("fileId");
	}

	public ClusterMessageFilePart setFileId(String value) {
		setStringProperty("fileId", value);
		return this;
	}

	public long getTotalLength() {
		return getLongProperty("totalLength");
	}

	public ClusterMessageFilePart setTotalLength(long value) {
		setLongProperty("totalLength", value);
		return this;
	}

	public boolean isInitialMessage() {
		return getBooleanProperty("initialMessage");
	}

	public ClusterMessageFilePart setInitialMessage(boolean value) {
		setBooleanProperty("initialMessage", value);
		return this;
	}

	public boolean isLastMessage() {
		return getBooleanProperty("lastMessage");
	}

	public ClusterMessageFilePart setLastMessage(boolean value) {
		setBooleanProperty("lastMessage", value);
		return this;
	}

	public byte[] getData() {
		return getByteArrayProperty("data");
	}

	public ClusterMessageFilePart setData(byte[] value) {
		setByteArrayProperty("data", value);
		return this;
	}



}