package org.teamapps.cluster.protocol;

import org.teamapps.protocol.schema.*;
import org.teamapps.protocol.service.*;
import org.teamapps.protocol.file.*;
import java.util.HashMap;
import java.util.Map;

public class ClusterModel {

	public static final MessageModelCollection MODEL_COLLECTION = new MessageModelCollection("ClusterModel", "org.teamapps.cluster.protocol", 1);


    static {
		ObjectPropertyDefinition clusterMessageFilePart = MODEL_COLLECTION.createModel("clusterMessageFilePart", "#tac.cmfp", 1, null, null);
		ObjectPropertyDefinition nodeInfo = MODEL_COLLECTION.createModel("nodeInfo", "#tac.ni", 1, null, null);
		ObjectPropertyDefinition clusterInfo = MODEL_COLLECTION.createModel("clusterInfo", "#tac.ci", 1, null, null);
		ObjectPropertyDefinition clusterMethodExecution = MODEL_COLLECTION.createModel("clusterMethodExecution", "#tac.cme", 1, null, null);

		clusterMessageFilePart.addProperty("fileId", 1, PropertyType.STRING, PropertyContentType.GENERIC, null, null);
		clusterMessageFilePart.addProperty("totalLength", 2, PropertyType.LONG, PropertyContentType.GENERIC, null, null);
		clusterMessageFilePart.addProperty("initialMessage", 3, PropertyType.BOOLEAN, PropertyContentType.GENERIC, null, null);
		clusterMessageFilePart.addProperty("lastMessage", 4, PropertyType.BOOLEAN, PropertyContentType.GENERIC, null, null);
		clusterMessageFilePart.addProperty("data", 5, PropertyType.BYTE_ARRAY, PropertyContentType.GENERIC, null, null);

		nodeInfo.addProperty("nodeId", 1, PropertyType.STRING, PropertyContentType.GENERIC, null, null);
		nodeInfo.addProperty("leader", 2, PropertyType.BOOLEAN, PropertyContentType.GENERIC, null, null);
		nodeInfo.addProperty("host", 3, PropertyType.STRING, PropertyContentType.GENERIC, null, null);
		nodeInfo.addProperty("port", 4, PropertyType.INT, PropertyContentType.GENERIC, null, null);
		nodeInfo.addProperty("reachable", 5, PropertyType.BOOLEAN, PropertyContentType.GENERIC, null, null);
		nodeInfo.addProperty("services", 6, PropertyType.STRING_ARRAY, PropertyContentType.GENERIC, null, null);

		clusterInfo.addProperty("initialMessage", 1, PropertyType.BOOLEAN, PropertyContentType.GENERIC, null, null);
		clusterInfo.addProperty("response", 2, PropertyType.BOOLEAN, PropertyContentType.GENERIC, null, null);
		clusterInfo.addSingleReference("localNode", 3, null, null, nodeInfo);
		clusterInfo.addMultiReference("remoteNodes", 4, null, null, nodeInfo);

		clusterMethodExecution.addProperty("response", 1, PropertyType.BOOLEAN, PropertyContentType.GENERIC, null, null);
		clusterMethodExecution.addProperty("requestId", 2, PropertyType.LONG, PropertyContentType.GENERIC, null, null);
		clusterMethodExecution.addProperty("serviceName", 3, PropertyType.STRING, PropertyContentType.GENERIC, null, null);
		clusterMethodExecution.addProperty("serviceMethod", 4, PropertyType.STRING, PropertyContentType.GENERIC, null, null);
		clusterMethodExecution.addProperty("data", 5, PropertyType.BYTE_ARRAY, PropertyContentType.GENERIC, null, null);


		MODEL_COLLECTION.addMessageDecoder(clusterMessageFilePart.getObjectUuid(), ClusterMessageFilePart.getMessageDecoder());
		MODEL_COLLECTION.addMessageDecoder(nodeInfo.getObjectUuid(), NodeInfo.getMessageDecoder());
		MODEL_COLLECTION.addMessageDecoder(clusterInfo.getObjectUuid(), ClusterInfo.getMessageDecoder());
		MODEL_COLLECTION.addMessageDecoder(clusterMethodExecution.getObjectUuid(), ClusterMethodExecution.getMessageDecoder());

    }



}