/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.core;

import java.util.ArrayList;
import java.util.List;
import org.teamapps.cluster.core.HostAddress;
import org.teamapps.cluster.core.Node;
import org.teamapps.cluster.protocol.NodeInfo;

public abstract class AbstractNode
implements Node {
    private String nodeId;
    private HostAddress hostAddress;
    private boolean externallyReachable;
    private boolean leader;
    private List<String> services = new ArrayList<String>();

    public AbstractNode() {
    }

    public AbstractNode(HostAddress hostAddress) {
        this.hostAddress = hostAddress;
        this.externallyReachable = true;
    }

    public AbstractNode(String nodeId, HostAddress hostAddress, boolean externallyReachable, boolean leader) {
        this.nodeId = nodeId;
        this.hostAddress = hostAddress;
        this.externallyReachable = externallyReachable;
        this.leader = leader;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public boolean isExternallyReachable() {
        return this.externallyReachable;
    }

    @Override
    public HostAddress getHostAddress() {
        return this.hostAddress;
    }

    @Override
    public List<String> getServices() {
        return this.services;
    }

    @Override
    public boolean isLeader() {
        return this.leader;
    }

    @Override
    public NodeInfo createNodeInfo() {
        return new NodeInfo().setNodeId(this.nodeId).setLeader(this.leader).setHost(this.hostAddress != null ? this.hostAddress.getHost() : null).setPort(this.hostAddress != null ? this.hostAddress.getPort() : 0).setServices(this.services != null ? this.services.toArray(new String[0]) : null);
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setHostAddress(HostAddress hostAddress) {
        this.hostAddress = hostAddress;
    }

    public void setExternallyReachable(boolean externallyReachable) {
        this.externallyReachable = externallyReachable;
    }

    public void setLeader(boolean leader) {
        this.leader = leader;
    }

    public void setServices(List<String> services) {
        this.services = services;
    }
}

