/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.core;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.cluster.core.Cluster;
import org.teamapps.cluster.core.ClusterHandler;
import org.teamapps.cluster.core.ClusterMessageHandler;
import org.teamapps.cluster.core.HostAddress;
import org.teamapps.cluster.core.LocalNode;
import org.teamapps.cluster.core.LocalNodeImpl;
import org.teamapps.cluster.core.MessageHandler;
import org.teamapps.cluster.core.Node;
import org.teamapps.cluster.core.RemoteNode;
import org.teamapps.cluster.core.RemoteNodeImpl;
import org.teamapps.cluster.protocol.ClusterInfo;
import org.teamapps.cluster.protocol.ClusterModel;
import org.teamapps.cluster.service.Utils;
import org.teamapps.protocol.schema.AbstractClusterService;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.ModelCollection;
import org.teamapps.protocol.schema.ModelRegistry;
import org.teamapps.protocol.schema.PojoObjectDecoder;

public class ClusterImpl
implements Cluster,
ClusterHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String clusterSecret;
    private final File tempDir;
    private final ModelRegistry modelRegistry;
    private final LocalNode localNode;
    private final HostAddress bindToAddress;
    private List<RemoteNode> remoteNodes = new ArrayList<RemoteNode>();
    private final Map<String, RemoteNode> remoteNodeById = new ConcurrentHashMap<String, RemoteNode>();
    private boolean active = true;
    private final Map<String, AbstractClusterService> localServices = new ConcurrentHashMap<String, AbstractClusterService>();
    private final Map<String, List<ClusterMessageHandler<? extends MessageObject>>> messageHandlersByModelUuid = new ConcurrentHashMap<String, List<ClusterMessageHandler<? extends MessageObject>>>();
    private final Map<String, List<ClusterMessageHandler<? extends MessageObject>>> messageHandlersByTopic = new ConcurrentHashMap<String, List<ClusterMessageHandler<? extends MessageObject>>>();
    private Map<String, List<RemoteNode>> clusterServicesByName = new HashMap<String, List<RemoteNode>>();
    private final ExecutorService executor = Executors.newFixedThreadPool(16);

    public ClusterImpl(String clusterSecret, String nodeId, boolean leader, HostAddress ... knownNodes) throws IOException {
        this(clusterSecret, nodeId, null, null, leader, knownNodes);
    }

    public ClusterImpl(String clusterSecret, String nodeId, HostAddress externalAddress, boolean leader, HostAddress ... knownNodes) throws IOException {
        this(clusterSecret, nodeId, externalAddress, externalAddress, leader, knownNodes);
    }

    public ClusterImpl(String clusterSecret, String nodeId, HostAddress externalAddress, HostAddress bindToAddress, boolean leader, HostAddress ... knownNodes) throws IOException {
        this(clusterSecret, Files.createTempDirectory("temp", new FileAttribute[0]).toFile(), nodeId, externalAddress, bindToAddress, leader, knownNodes);
    }

    public ClusterImpl(String clusterSecret, File tempDir, String nodeId, HostAddress externalAddress, HostAddress bindToAddress, boolean leader, HostAddress ... knownNodes) {
        this.clusterSecret = clusterSecret;
        this.tempDir = tempDir;
        this.modelRegistry = ClusterModel.MODEL_COLLECTION.createRegistry();
        this.bindToAddress = bindToAddress;
        this.localNode = new LocalNodeImpl(nodeId, externalAddress, externalAddress != null && bindToAddress != null, leader);
        if (this.localNode.isExternallyReachable()) {
            this.startServerSocket();
        }
        if (knownNodes != null) {
            for (HostAddress hostAddress : knownNodes) {
                this.createRemoteNode(hostAddress);
            }
        }
        this.block();
    }

    public void block() {
        new Thread(() -> {
            while (this.active) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }).start();
    }

    private void createRemoteNode(HostAddress hostAddress) {
        if (!this.localNode.isExternallyReachable() || this.isOutboundConnection(this.localNode.getHostAddress(), hostAddress)) {
            this.remoteNodes.add(new RemoteNodeImpl(hostAddress, (ClusterHandler)this, this.modelRegistry, this.tempDir, this.clusterSecret));
        }
    }

    private boolean isOutboundConnection(HostAddress localAddress, HostAddress remoteAddress) {
        return (localAddress.getHost() + localAddress.getPort()).compareTo(remoteAddress.getHost() + remoteAddress.getPort()) < 0;
    }

    private void startServerSocket() {
        String host = this.bindToAddress.getHost() != null ? this.bindToAddress.getHost() : "0.0.0.0";
        Thread thread = new Thread(() -> {
            try {
                ServerSocket serverSocket = new ServerSocket(this.bindToAddress.getPort(), 50, InetAddress.getByName(host));
                while (this.active) {
                    try {
                        Socket socket = serverSocket.accept();
                        new RemoteNodeImpl(socket, (ClusterHandler)this, this.modelRegistry, this.tempDir, this.clusterSecret);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        thread.setName("server-socket-" + host + "-" + this.bindToAddress.getPort());
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public ClusterInfo getClusterInfo() {
        return new ClusterInfo().setLocalNode(this.localNode.createNodeInfo()).setRemoteNodes(this.remoteNodes.stream().map(Node::createNodeInfo).collect(Collectors.toList()));
    }

    @Override
    public void handleNodeConnected(RemoteNode node, ClusterInfo clusterInfo) {
        ArrayList<RemoteNode> nodesCopy = new ArrayList<RemoteNode>(this.remoteNodes);
        RemoteNode remoteNode = this.remoteNodeById.get(node.getNodeId());
        if (remoteNode != null) {
            LOGGER.info("Existing node reconnected:" + node);
            node.recycleNode(remoteNode);
            this.remoteNodeById.put(node.getNodeId(), node);
            nodesCopy.remove(remoteNode);
            nodesCopy.add(node);
            this.remoteNodes = nodesCopy;
        } else {
            LOGGER.info("New node connected:" + node);
            this.remoteNodeById.put(node.getNodeId(), node);
            nodesCopy.add(node);
            this.remoteNodes = nodesCopy;
        }
        this.handleClusterUpdate();
    }

    @Override
    public void handleNodeDisconnected(RemoteNode node) {
    }

    @Override
    public void handleClusterUpdate() {
        HashMap<String, List<RemoteNode>> serviceMap = new HashMap<String, List<RemoteNode>>();
        for (RemoteNode clusterNode : this.remoteNodes) {
            for (String service : clusterNode.getServices()) {
                serviceMap.putIfAbsent(service, new ArrayList());
                ((List)serviceMap.get(service)).add(clusterNode);
            }
        }
        this.clusterServicesByName = serviceMap;
    }

    @Override
    public void addModelCollection(ModelCollection modelCollection) {
        this.modelRegistry.addModelCollection(modelCollection);
    }

    @Override
    public LocalNode getLocalNode() {
        return this.localNode;
    }

    @Override
    public List<RemoteNode> getRemoteNodes() {
        return this.remoteNodes;
    }

    @Override
    public void addRemoteNode(RemoteNode remoteNode) {
    }

    @Override
    public RemoteNode getRemoteNode(String nodeId) {
        return this.remoteNodes.stream().filter(node -> node.getNodeId().equals(nodeId)).findFirst().orElse(null);
    }

    public void registerService(AbstractClusterService clusterService) {
        this.localServices.put(clusterService.getServiceName(), clusterService);
        this.localNode.getServices().add(clusterService.getServiceName());
        this.sendMessageToAllNodes(this.getClusterInfo(), false);
    }

    public void registerModelCollection(ModelCollection modelCollection) {
        this.modelRegistry.addModelCollection(modelCollection);
    }

    @Override
    public boolean isServiceAvailable(String serviceName) {
        List nodesWithService = this.clusterServicesByName.getOrDefault(serviceName, Collections.emptyList());
        return !nodesWithService.isEmpty();
    }

    public RemoteNode getRandomServiceProvider(String serviceName) {
        List nodesWithService = this.clusterServicesByName.getOrDefault(serviceName, Collections.emptyList()).stream().filter(RemoteNode::isConnected).collect(Collectors.toList());
        return (RemoteNode)Utils.randomListEntry(nodesWithService);
    }

    public <REQUEST extends MessageObject, RESPONSE extends MessageObject> RESPONSE executeServiceMethod(String serviceName, String method, REQUEST request, PojoObjectDecoder<RESPONSE> responseDecoder) {
        RemoteNode serviceProvider = this.getRandomServiceProvider(serviceName);
        LOGGER.info("Execute cluster method: {}, {}", (Object)serviceName, (Object)method);
        if (serviceProvider == null) {
            LOGGER.info("Service method not executed: missing service provider: {}", (Object)serviceName);
            return null;
        }
        RESPONSE response = serviceProvider.executeServiceMethod(serviceName, method, request, responseDecoder);
        return response;
    }

    private void sendMessageToAllNodes(MessageObject message, boolean resendOnError) {
        this.remoteNodes.forEach(node -> node.sendMessage(message, resendOnError));
    }

    public void sendMessage(MessageObject message, String nodeId) {
        RemoteNode remoteNode = this.getRemoteNode(nodeId);
        if (remoteNode != null) {
            remoteNode.sendMessage(message, false);
        } else {
            LOGGER.info("Cannot send message to missing nose: {}", (Object)nodeId);
        }
    }

    public void sendTopicMessage(String topic, MessageObject message) {
    }

    @Override
    public void handleMessage(MessageObject message, RemoteNode node) {
        String modelUuid = message.getModel().getModelUuid();
        List<ClusterMessageHandler<? extends MessageObject>> clusterMessageHandlers = this.messageHandlersByModelUuid.get(modelUuid);
        if (clusterMessageHandlers != null) {
            clusterMessageHandlers.forEach(handler -> handler.handleMessage(message, node.getNodeId(), this.executor));
        }
    }

    @Override
    public void handleTopicMessage(String topic, MessageObject message, RemoteNode node) {
        List<ClusterMessageHandler<? extends MessageObject>> clusterMessageHandlers = this.messageHandlersByTopic.get(topic);
        if (clusterMessageHandlers != null) {
            clusterMessageHandlers.forEach(handler -> handler.handleMessage(message, node.getNodeId(), this.executor));
        }
    }

    @Override
    public <MESSAGE extends MessageObject> void registerMessageHandler(MessageHandler<MESSAGE> messageHandler, PojoObjectDecoder<MESSAGE> messageDecoder) {
        this.messageHandlersByModelUuid.computeIfAbsent(messageDecoder.getMessageObjectUuid(), s -> new ArrayList()).add(new ClusterMessageHandler<MESSAGE>(messageHandler, messageDecoder));
    }

    @Override
    public <MESSAGE extends MessageObject> void registerTopicHandler(String topic, MessageHandler<MESSAGE> messageHandler, PojoObjectDecoder<MESSAGE> messageDecoder) {
        this.messageHandlersByTopic.computeIfAbsent(topic, s -> new ArrayList()).add(new ClusterMessageHandler<MESSAGE>(messageHandler, messageDecoder));
    }

    @Override
    public MessageObject handleClusterServiceMethod(String service, String serviceMethod, MessageObject requestData) {
        AbstractClusterService clusterService = this.localServices.get(service);
        if (clusterService != null) {
            return clusterService.handleMessage(serviceMethod, requestData);
        }
        LOGGER.warn("Cannot handle cluster service method: missing service: {}", (Object)service);
        return null;
    }

    @Override
    public void shutDown() {
        for (RemoteNode clusterNode : this.remoteNodes) {
            clusterNode.shutDown();
        }
    }
}

