/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.core;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.cluster.core.AbstractNode;
import org.teamapps.cluster.core.ClusterHandler;
import org.teamapps.cluster.core.Connection;
import org.teamapps.cluster.core.ConnectionHandler;
import org.teamapps.cluster.core.HostAddress;
import org.teamapps.cluster.core.MessageQueue;
import org.teamapps.cluster.core.MessageQueueEntry;
import org.teamapps.cluster.core.NetworkConnection;
import org.teamapps.cluster.core.RemoteNode;
import org.teamapps.cluster.protocol.ClusterInfo;
import org.teamapps.cluster.protocol.NodeInfo;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.ModelRegistry;
import org.teamapps.protocol.schema.PojoObjectDecoder;

public class RemoteNodeImpl
extends AbstractNode
implements RemoteNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(2);
    private final ClusterHandler clusterHandler;
    private final ModelRegistry modelRegistry;
    private File tempDir;
    private String clusterSecret;
    private final boolean outboundConnection;
    private final MessageQueue messageQueue = new MessageQueue();
    private Connection connection;
    private int retries;
    private boolean running = true;
    private ClusterInfo lastClusterInfo;
    private AtomicLong serviceRequestIdGenerator = new AtomicLong();
    private Map<Long, CompletableFuture<MessageObject>> serviceRequestMap = new ConcurrentHashMap<Long, CompletableFuture<MessageObject>>();
    private long sentBytes;
    private long receivedBytes;
    private long sentMessages;
    private long receivedMessages;
    private long establishedConnectionsCount;
    private long lastConnectedTimestamp;

    public RemoteNodeImpl(HostAddress hostAddress, ClusterHandler clusterHandler, ModelRegistry modelRegistry, File tempDir, String clusterSecret) {
        super(hostAddress);
        this.clusterHandler = clusterHandler;
        this.modelRegistry = modelRegistry;
        this.tempDir = tempDir;
        this.clusterSecret = clusterSecret;
        this.outboundConnection = true;
        this.connect();
    }

    public RemoteNodeImpl(Socket socket, ClusterHandler clusterHandler, ModelRegistry modelRegistry, File tempDir, String clusterSecret) {
        this.clusterHandler = clusterHandler;
        this.modelRegistry = modelRegistry;
        this.outboundConnection = false;
        new NetworkConnection(socket, this.messageQueue, (ConnectionHandler)this, modelRegistry, tempDir, clusterSecret);
    }

    private void connect() {
        new NetworkConnection(this.getHostAddress(), this.messageQueue, (ConnectionHandler)this, this.modelRegistry, this.tempDir, this.clusterSecret);
    }

    private void startKeepAliveService() {
        scheduledExecutorService.scheduleAtFixedRate(() -> {
            if (this.isConnected() && System.currentTimeMillis() - this.connection.getLastMessageTimestamp() > 60000L) {
                this.connection.sendKeepAlive();
            }
        }, 90L, 90L, TimeUnit.SECONDS);
    }

    @Override
    public ClusterInfo getClusterInfo() {
        return this.clusterHandler.getClusterInfo();
    }

    @Override
    public void handleConnectionEstablished(Connection connection, ClusterInfo clusterInfo) {
        this.updateClusterInfo(clusterInfo);
        this.lastConnectedTimestamp = System.currentTimeMillis();
        if (this.establishedConnectionsCount == 0L) {
            this.startKeepAliveService();
        }
        ++this.establishedConnectionsCount;
        this.retries = 0;
        this.connection = connection;
        this.clusterHandler.handleNodeConnected(this, clusterInfo);
        LOGGER.info("Remote connection established: {}, {}", (Object)this.getNodeId(), (Object)this.getHostAddress());
    }

    @Override
    public void handleClusterInfoUpdate(ClusterInfo clusterInfo) {
        this.updateClusterInfo(clusterInfo);
        this.clusterHandler.handleClusterUpdate();
    }

    private void updateClusterInfo(ClusterInfo clusterInfo) {
        NodeInfo localNode = clusterInfo.getLocalNode();
        this.setNodeId(localNode.getNodeId());
        this.setHostAddress(new HostAddress(localNode.getHost(), localNode.getPort()));
        this.setLeader(localNode.isLeader());
        this.setServices(localNode.getServices() != null ? Arrays.asList(localNode.getServices()) : Collections.emptyList());
        this.lastClusterInfo = clusterInfo;
    }

    @Override
    public void handleConnectionClosed() {
        LOGGER.info("Remote connection closed: {}, {}", (Object)this.getNodeId(), (Object)this.getHostAddress());
        if (this.connection != null) {
            this.receivedBytes += this.connection.getReceivedBytes();
            this.receivedMessages += this.connection.getReceivedMessages();
            this.sentBytes += this.connection.getSentBytes();
            this.sentMessages += this.connection.getSentMessages();
        }
        this.connection = null;
        ++this.retries;
        this.clusterHandler.handleNodeDisconnected(this);
        if (this.outboundConnection && this.running) {
            scheduledExecutorService.schedule(this::connect, this.retries < 10 ? 3L : 15L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void handleMessage(MessageObject message) {
        this.clusterHandler.handleMessage(message, this);
    }

    @Override
    public void handleClusterExecutionRequest(String serviceName, String serviceMethod, MessageObject message, long requestId) {
        MessageObject result = this.clusterHandler.handleClusterServiceMethod(serviceName, serviceMethod, message);
        this.addMessageToSendQueue(new MessageQueueEntry(true, true, result, serviceName, serviceMethod, true, requestId));
    }

    @Override
    public void handleClusterExecutionResult(MessageObject message, long requestId) {
        CompletableFuture<MessageObject> completableFuture = this.serviceRequestMap.remove(requestId);
        if (completableFuture != null) {
            completableFuture.complete(message);
        }
    }

    @Override
    public void recycleNode(RemoteNode node) {
        this.messageQueue.reuseQueue(node.getMessageQueue());
    }

    @Override
    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    @Override
    public boolean isOutbound() {
        return this.outboundConnection;
    }

    @Override
    public void shutDown() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
            this.running = false;
            scheduledExecutorService.shutdownNow();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public MessageQueue getMessageQueue() {
        return this.messageQueue;
    }

    @Override
    public long getSentBytes() {
        return this.sentBytes + (this.connection != null ? this.connection.getSentBytes() : 0L);
    }

    @Override
    public long getReceivedBytes() {
        return this.receivedBytes + (this.connection != null ? this.connection.getReceivedBytes() : 0L);
    }

    @Override
    public long getSentMessages() {
        return this.sentMessages + (this.connection != null ? this.connection.getSentMessages() : 0L);
    }

    @Override
    public long getReceivedMessages() {
        return this.receivedMessages + (this.connection != null ? this.connection.getReceivedMessages() : 0L);
    }

    @Override
    public long getReconnects() {
        return this.establishedConnectionsCount - 1L;
    }

    @Override
    public long getConnectedSince() {
        return this.lastConnectedTimestamp;
    }

    @Override
    public void sendMessage(MessageObject message, boolean resendOnError) {
        if (this.isConnected() && message != null) {
            this.addMessageToSendQueue(new MessageQueueEntry(resendOnError, message));
        } else {
            LOGGER.warn("Cannot send message, connected: {}, message: {}", (Object)this.isConnected(), (Object)(message != null ? message.getMessageDefName() : "is NULL!"));
        }
    }

    @Override
    public <REQUEST extends MessageObject, RESPONSE extends MessageObject> RESPONSE executeServiceMethod(String service, String serviceMethod, REQUEST request, PojoObjectDecoder<RESPONSE> responseDecoder) {
        if (this.isConnected() && request != null && responseDecoder != null) {
            long requestId = this.serviceRequestIdGenerator.incrementAndGet();
            CompletableFuture completableFuture = new CompletableFuture();
            this.serviceRequestMap.put(requestId, completableFuture);
            this.addMessageToSendQueue(new MessageQueueEntry(true, true, request, service, serviceMethod, false, requestId));
            try {
                MessageObject response = (MessageObject)completableFuture.get();
                return (RESPONSE)responseDecoder.remap(response);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private void addMessageToSendQueue(MessageQueueEntry entry) {
        if (!this.messageQueue.addMessage(entry)) {
            LOGGER.warn("Error message queue is full, dropping connection: {}, {}", (Object)this.getNodeId(), (Object)this.getHostAddress());
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }

    public String toString() {
        return this.getNodeId() + ", " + this.getHostAddress();
    }
}

