/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.protocol;

import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.cluster.protocol.ClusterModel;
import org.teamapps.cluster.protocol.NodeInfo;
import org.teamapps.protocol.file.FileProvider;
import org.teamapps.protocol.schema.MessageModel;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.ModelCollection;
import org.teamapps.protocol.schema.PojoObjectDecoder;
import org.teamapps.protocol.schema.PojoObjectDecoderRegistry;

public class ClusterInfo
extends MessageObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PojoObjectDecoder<ClusterInfo> decoder = new PojoObjectDecoder<ClusterInfo>(){

        public ClusterInfo decode(DataInputStream dis, FileProvider fileProvider) {
            try {
                return new ClusterInfo(dis, fileProvider);
            }
            catch (IOException e) {
                LOGGER.error("Error creating ClusterInfo instance", (Throwable)e);
                return null;
            }
        }

        public ClusterInfo decode(ByteBuf buf, FileProvider fileProvider) {
            try {
                return new ClusterInfo(buf, fileProvider);
            }
            catch (IOException e) {
                LOGGER.error("Error creating ClusterInfo instance", (Throwable)e);
                return null;
            }
        }

        public ClusterInfo remap(MessageObject message) {
            return new ClusterInfo(message, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
        }

        public String getMessageObjectUuid() {
            return ClusterInfo.OBJECT_UUID;
        }
    };
    public static final String OBJECT_UUID = "#tac.ci";

    public static PojoObjectDecoder<ClusterInfo> getMessageDecoder() {
        return decoder;
    }

    public static MessageModel getMessageModel() {
        return ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

    public static ModelCollection getModelCollection() {
        return ClusterModel.MODEL_COLLECTION;
    }

    public static ClusterInfo remap(MessageObject message) {
        return new ClusterInfo(message, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
    }

    public ClusterInfo() {
        super(ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID));
    }

    public ClusterInfo(MessageObject message, PojoObjectDecoderRegistry pojoObjectDecoderRegistry) {
        super(message, pojoObjectDecoderRegistry);
    }

    public ClusterInfo(DataInputStream dis) throws IOException {
        super(dis, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), null, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
    }

    public ClusterInfo(DataInputStream dis, FileProvider fileProvider) throws IOException {
        super(dis, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
    }

    public ClusterInfo(ByteBuf buf, FileProvider fileProvider) throws IOException {
        super(buf, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
    }

    public ClusterInfo(byte[] bytes) throws IOException {
        super(bytes, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), null, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
    }

    public ClusterInfo(byte[] bytes, FileProvider fileProvider) throws IOException {
        super(bytes, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
    }

    public boolean isInitialMessage() {
        return this.getBooleanProperty("initialMessage");
    }

    public ClusterInfo setInitialMessage(boolean value) {
        this.setBooleanProperty("initialMessage", value);
        return this;
    }

    public boolean isResponse() {
        return this.getBooleanProperty("response");
    }

    public ClusterInfo setResponse(boolean value) {
        this.setBooleanProperty("response", value);
        return this;
    }

    public NodeInfo getLocalNode() {
        return (NodeInfo)this.getReferencedObjectAsType("localNode");
    }

    public ClusterInfo setLocalNode(NodeInfo value) {
        this.setReferencedObjectAsType("localNode", value);
        return this;
    }

    public List<NodeInfo> getRemoteNodes() {
        return this.getReferencedObjectsAsType("remoteNodes");
    }

    public ClusterInfo setRemoteNodes(List<NodeInfo> value) {
        this.setReferencedObjectsAsType("remoteNodes", value);
        return this;
    }

    public ClusterInfo addRemoteNodes(NodeInfo value) {
        this.addReference("remoteNodes", value);
        return this;
    }
}

