/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.protocol;

import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.cluster.protocol.ClusterModel;
import org.teamapps.protocol.file.FileProvider;
import org.teamapps.protocol.schema.MessageModel;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.ModelCollection;
import org.teamapps.protocol.schema.PojoObjectDecoder;
import org.teamapps.protocol.schema.PojoObjectDecoderRegistry;

public class NodeInfo
extends MessageObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PojoObjectDecoder<NodeInfo> decoder = new PojoObjectDecoder<NodeInfo>(){

        public NodeInfo decode(DataInputStream dis, FileProvider fileProvider) {
            try {
                return new NodeInfo(dis, fileProvider);
            }
            catch (IOException e) {
                LOGGER.error("Error creating NodeInfo instance", (Throwable)e);
                return null;
            }
        }

        public NodeInfo decode(ByteBuf buf, FileProvider fileProvider) {
            try {
                return new NodeInfo(buf, fileProvider);
            }
            catch (IOException e) {
                LOGGER.error("Error creating NodeInfo instance", (Throwable)e);
                return null;
            }
        }

        public NodeInfo remap(MessageObject message) {
            return new NodeInfo(message, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
        }

        public String getMessageObjectUuid() {
            return NodeInfo.OBJECT_UUID;
        }
    };
    public static final String OBJECT_UUID = "#tac.ni";

    public static PojoObjectDecoder<NodeInfo> getMessageDecoder() {
        return decoder;
    }

    public static MessageModel getMessageModel() {
        return ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID);
    }

    public static ModelCollection getModelCollection() {
        return ClusterModel.MODEL_COLLECTION;
    }

    public static NodeInfo remap(MessageObject message) {
        return new NodeInfo(message, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
    }

    public NodeInfo() {
        super(ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID));
    }

    public NodeInfo(MessageObject message, PojoObjectDecoderRegistry pojoObjectDecoderRegistry) {
        super(message, pojoObjectDecoderRegistry);
    }

    public NodeInfo(DataInputStream dis) throws IOException {
        super(dis, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), null, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
    }

    public NodeInfo(DataInputStream dis, FileProvider fileProvider) throws IOException {
        super(dis, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
    }

    public NodeInfo(ByteBuf buf, FileProvider fileProvider) throws IOException {
        super(buf, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
    }

    public NodeInfo(byte[] bytes) throws IOException {
        super(bytes, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), null, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
    }

    public NodeInfo(byte[] bytes, FileProvider fileProvider) throws IOException {
        super(bytes, ClusterModel.MODEL_COLLECTION.getModel(OBJECT_UUID), fileProvider, (PojoObjectDecoderRegistry)ClusterModel.MODEL_COLLECTION);
    }

    public String getNodeId() {
        return this.getStringProperty("nodeId");
    }

    public NodeInfo setNodeId(String value) {
        this.setStringProperty("nodeId", value);
        return this;
    }

    public boolean isLeader() {
        return this.getBooleanProperty("leader");
    }

    public NodeInfo setLeader(boolean value) {
        this.setBooleanProperty("leader", value);
        return this;
    }

    public String getHost() {
        return this.getStringProperty("host");
    }

    public NodeInfo setHost(String value) {
        this.setStringProperty("host", value);
        return this;
    }

    public int getPort() {
        return this.getIntProperty("port");
    }

    public NodeInfo setPort(int value) {
        this.setIntProperty("port", value);
        return this;
    }

    public boolean isReachable() {
        return this.getBooleanProperty("reachable");
    }

    public NodeInfo setReachable(boolean value) {
        this.setBooleanProperty("reachable", value);
        return this;
    }

    public String[] getServices() {
        return this.getStringArrayProperty("services");
    }

    public NodeInfo setServices(String[] value) {
        this.setStringArrayProperty("services", value);
        return this;
    }
}

