/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.state;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.teamapps.cluster.state.ChangeOperation;
import org.teamapps.protocol.file.FileProvider;
import org.teamapps.protocol.file.FileSink;
import org.teamapps.protocol.message.MessageUtils;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.ModelRegistry;

public class StateUpdateMessage {
    private final String subStateId;
    private final ChangeOperation operation;
    private final String identifier;
    private final MessageObject message;

    public StateUpdateMessage(String subStateId, ChangeOperation operation, String identifier, MessageObject message) {
        this.subStateId = subStateId;
        this.operation = operation;
        this.identifier = identifier;
        this.message = message;
    }

    public StateUpdateMessage(DataInputStream dis, ModelRegistry modelRegistry, FileProvider fileProvider) throws IOException {
        this.subStateId = MessageUtils.readString((DataInputStream)dis);
        this.operation = ChangeOperation.getById(dis.readUnsignedByte());
        this.identifier = MessageUtils.readString((DataInputStream)dis);
        this.message = new MessageObject(dis, modelRegistry, fileProvider, null);
    }

    public String getSubStateId() {
        return this.subStateId;
    }

    public ChangeOperation getOperation() {
        return this.operation;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public MessageObject getMessage() {
        return this.message;
    }

    public void write(DataOutputStream dos, FileSink fileSink) throws IOException {
        MessageUtils.writeString((DataOutputStream)dos, (String)this.subStateId);
        dos.writeByte(this.operation.getId());
        MessageUtils.writeString((DataOutputStream)dos, (String)this.identifier);
        this.message.write(dos, fileSink);
    }

    public byte[] toBytes(FileSink fileSink) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.write(dos, fileSink);
        dos.flush();
        return bos.toByteArray();
    }
}

