/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.core;

import java.util.concurrent.ExecutorService;
import org.teamapps.cluster.core.MessageHandler;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.PojoObjectDecoder;

public class ClusterMessageHandler<MESSAGE extends MessageObject> {
    private final MessageHandler<MESSAGE> messageHandler;
    private final PojoObjectDecoder<MESSAGE> messageDecoder;

    public ClusterMessageHandler(MessageHandler<MESSAGE> messageHandler, PojoObjectDecoder<MESSAGE> messageDecoder) {
        this.messageHandler = messageHandler;
        this.messageDecoder = messageDecoder;
    }

    public void handleMessage(MessageObject message, String nodeId, ExecutorService executorService) {
        executorService.submit(() -> {
            MessageObject remappedMessage = this.messageDecoder.remap(message);
            this.messageHandler.handleMessage(remappedMessage, nodeId);
        });
    }
}

