/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.Socket;
import java.nio.file.Files;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.cluster.core.Connection;
import org.teamapps.cluster.core.ConnectionHandler;
import org.teamapps.cluster.core.HostAddress;
import org.teamapps.cluster.core.MessageQueue;
import org.teamapps.cluster.core.MessageQueueEntry;
import org.teamapps.cluster.crypto.AesCipher;
import org.teamapps.cluster.protocol.ClusterInfo;
import org.teamapps.cluster.protocol.ClusterMessageFilePart;
import org.teamapps.cluster.protocol.ClusterMethodExecution;
import org.teamapps.protocol.file.FileProvider;
import org.teamapps.protocol.file.FileSink;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.ModelRegistry;

public class NetworkConnection
implements Connection {
    public static final int MAX_MESSAGE_SIZE = 100000000;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(2);
    private HostAddress remoteHostAddress;
    private MessageQueue messageQueue;
    private ConnectionHandler connectionHandler;
    private ModelRegistry modelRegistry;
    private AesCipher aesCipher;
    private File tempDir;
    private volatile boolean connected;
    private Socket socket;
    private DataInputStream dataInputStream;
    private DataOutputStream dataOutputStream;
    private long lastMessageTimestamp;
    private long sentBytes;
    private long receivedBytes;
    private long sentMessages;
    private long receivedMessages;

    public NetworkConnection(Socket socket, MessageQueue messageQueue, ConnectionHandler connectionHandler, ModelRegistry modelRegistry, File tempDir, String clusterSecret) {
        this.socket = socket;
        this.messageQueue = messageQueue;
        this.modelRegistry = modelRegistry;
        this.connectionHandler = connectionHandler;
        this.tempDir = tempDir;
        this.aesCipher = new AesCipher(clusterSecret);
        this.connected = true;
        this.remoteHostAddress = new HostAddress(socket.getRemoteSocketAddress().toString(), socket.getPort());
        this.handleSocket(socket);
        this.startReaderThread();
        this.startWriterThread();
    }

    public NetworkConnection(HostAddress hostAddress, MessageQueue messageQueue, ConnectionHandler connectionHandler, ModelRegistry modelRegistry, File tempDir, String clusterSecret) {
        this.messageQueue = messageQueue;
        this.modelRegistry = modelRegistry;
        this.connectionHandler = connectionHandler;
        this.tempDir = tempDir;
        this.aesCipher = new AesCipher(clusterSecret);
        this.remoteHostAddress = hostAddress;
        this.connect(hostAddress);
        if (this.connected) {
            this.startReaderThread();
            this.startWriterThread();
            this.writeDirectMessage(connectionHandler.getClusterInfo().setInitialMessage(true));
        }
    }

    private void connect(HostAddress hostAddress) {
        try {
            this.socket = new Socket(hostAddress.getHost(), hostAddress.getPort());
            this.connected = true;
            this.handleSocket(this.socket);
        }
        catch (IOException e) {
            this.close();
        }
    }

    protected void handleSocket(Socket socket) {
        try {
            socket.setKeepAlive(true);
            socket.setTcpNoDelay(true);
            this.dataInputStream = new DataInputStream(socket.getInputStream());
            this.dataOutputStream = new DataOutputStream(socket.getOutputStream());
        }
        catch (IOException e) {
            this.close();
        }
    }

    private void startReaderThread() {
        Thread thread = new Thread(() -> {
            while (this.connected) {
                try {
                    int messageSize = this.dataInputStream.readInt();
                    if (messageSize > 0 && messageSize < 100000000) {
                        byte[] data = new byte[messageSize];
                        this.dataInputStream.readFully(data);
                        byte[] messageData = this.aesCipher.decrypt(data);
                        this.handleMessageData(messageData);
                        this.receivedBytes += (long)(messageSize + 4);
                        ++this.receivedMessages;
                        this.lastMessageTimestamp = System.currentTimeMillis();
                        continue;
                    }
                    this.close();
                }
                catch (Exception e) {
                    this.close();
                }
            }
        });
        thread.setName("connection-reader-" + this.socket.getInetAddress().getHostAddress() + "-" + this.socket.getPort());
        thread.setDaemon(true);
        thread.start();
    }

    private void startWriterThread() {
        Thread thread = new Thread(() -> {
            while (this.connected) {
                try {
                    MessageQueueEntry queueEntry = this.messageQueue.getNext();
                    if (queueEntry.isServiceExecution()) {
                        byte[] value = queueEntry.getMessage() == null ? null : queueEntry.getMessage().toBytes((FileSink)this);
                        ClusterMethodExecution clusterMethodExecution = new ClusterMethodExecution().setRequestId(queueEntry.getRequestId()).setServiceName(queueEntry.getServiceName()).setServiceMethod(queueEntry.getServiceMethod()).setResponse(queueEntry.isServiceResponse()).setData(value);
                        byte[] bytes = clusterMethodExecution.toBytes();
                        byte[] data = this.aesCipher.encrypt(bytes);
                        this.writeData(data);
                    } else {
                        MessageObject message = queueEntry.getMessage();
                        byte[] bytes = message.toBytes((FileSink)this);
                        byte[] data = this.aesCipher.encrypt(bytes);
                        this.writeData(data);
                    }
                    this.messageQueue.commitLastMessage();
                }
                catch (InterruptedException queueEntry) {
                }
                catch (Exception exception) {
                    this.close();
                }
            }
        });
        thread.setDaemon(true);
        thread.setName("connection-writer-" + this.socket.getInetAddress().getHostAddress() + "-" + this.socket.getPort());
        thread.start();
    }

    private void handleMessageData(byte[] messageData) {
        try {
            String objectUuid;
            switch (objectUuid = MessageObject.readMessageObjectUuid((byte[])messageData)) {
                case "#tac.cmfp": {
                    this.handleClusterMessageFilePart(new ClusterMessageFilePart(messageData, (FileProvider)this));
                    break;
                }
                case "#tac.ci": {
                    this.handleClusterInfo(new ClusterInfo(messageData, (FileProvider)this));
                    break;
                }
                case "#tac.cme": {
                    this.handleClusterMethodExecution(new ClusterMethodExecution(messageData, (FileProvider)this));
                    break;
                }
                default: {
                    this.connectionHandler.handleMessage(new MessageObject(messageData, this.modelRegistry, (FileProvider)this, null));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleClusterMethodExecution(ClusterMethodExecution methodExecution) throws IOException {
        MessageObject messageObject;
        MessageObject messageObject2 = messageObject = methodExecution.getData() == null ? null : new MessageObject(methodExecution.getData(), this.modelRegistry, (FileProvider)this, null);
        if (!methodExecution.isResponse()) {
            this.connectionHandler.handleClusterExecutionRequest(methodExecution.getServiceName(), methodExecution.getServiceMethod(), messageObject, methodExecution.getRequestId());
        } else {
            this.connectionHandler.handleClusterExecutionResult(messageObject, methodExecution.getRequestId());
        }
    }

    private void writeDirectMessage(MessageObject message) {
        try {
            if (this.connected) {
                byte[] bytes = message.toBytes((FileSink)this);
                byte[] data = this.aesCipher.encrypt(bytes);
                this.writeData(data);
            }
        }
        catch (Exception e) {
            this.close();
        }
    }

    private synchronized void writeData(byte[] bytes) {
        try {
            this.dataOutputStream.writeInt(bytes.length);
            this.dataOutputStream.write(bytes);
            this.dataOutputStream.flush();
            this.sentBytes += (long)(bytes.length + 4);
            ++this.sentMessages;
            this.lastMessageTimestamp = System.currentTimeMillis();
        }
        catch (Exception e) {
            this.close();
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void close() {
        if (!this.connected) {
            return;
        }
        LOGGER.info("Closed connection {}", (Object)this.remoteHostAddress);
        try {
            this.connected = false;
            if (this.socket != null) {
                this.socket.close();
            }
            this.messageQueue.recycleQueue();
        }
        catch (Exception exception) {
        }
        finally {
            this.socket = null;
            this.dataOutputStream = null;
            this.dataInputStream = null;
            this.connectionHandler.handleConnectionClosed();
        }
    }

    @Override
    public long getLastMessageTimestamp() {
        return this.lastMessageTimestamp;
    }

    @Override
    public long getSentBytes() {
        return this.sentBytes;
    }

    @Override
    public long getReceivedBytes() {
        return this.receivedBytes;
    }

    @Override
    public long getSentMessages() {
        return this.sentMessages;
    }

    @Override
    public long getReceivedMessages() {
        return this.receivedMessages;
    }

    @Override
    public void sendKeepAlive() {
    }

    private void handleClusterInfo(ClusterInfo clusterInfo) {
        LOGGER.info("Handle cluster info:" + clusterInfo);
        if (!clusterInfo.isResponse()) {
            this.writeDirectMessage(this.connectionHandler.getClusterInfo().setResponse(true).setInitialMessage(clusterInfo.isInitialMessage()));
        }
        if (clusterInfo.isInitialMessage()) {
            this.connectionHandler.handleConnectionEstablished(this, clusterInfo);
        } else {
            this.connectionHandler.handleClusterInfoUpdate(clusterInfo);
        }
    }

    private void handleClusterMessageFilePart(ClusterMessageFilePart filePart) {
        try {
            long length = this.appendFileTransferData(filePart.getFileId(), filePart.getData(), filePart.isInitialMessage());
            if (filePart.isLastMessage() && length != filePart.getTotalLength()) {
                LOGGER.error("Wrong cluster message file size, expected: {}, actual: {}", (Object)filePart.getTotalLength(), (Object)length);
                this.close();
            }
        }
        catch (IOException e) {
            this.close();
        }
    }

    private File getClusterTransferFile(String fileId) {
        return new File(this.tempDir, fileId + ".tmp");
    }

    private long appendFileTransferData(String fileId, byte[] bytes, boolean initialData) throws IOException {
        File file = this.getClusterTransferFile(fileId);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file, !initialData), 32000);
        bos.write(bytes);
        bos.close();
        return file.length();
    }

    public File getFile(String fileId) {
        return this.getClusterTransferFile(fileId);
    }

    public String handleFile(File file) throws IOException {
        int maxContentSize;
        if (file == null || file.length() == 0L || !this.connected) {
            return null;
        }
        String fileId = UUID.randomUUID().toString().replace("-", ".");
        long fileLength = file.length();
        int parts = (int)((fileLength - 1L) / (long)(maxContentSize = 10000000)) + 1;
        if (parts == 1) {
            byte[] bytes = Files.readAllBytes(file.toPath());
            this.writeDirectMessage(new ClusterMessageFilePart().setFileId(fileId).setTotalLength(fileLength).setLastMessage(true).setData(bytes));
        } else {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            for (int i = 0; i < parts; ++i) {
                boolean lastMessage;
                int length = maxContentSize;
                boolean bl = lastMessage = i + 1 == parts;
                if (lastMessage) {
                    length = (int)(fileLength - (long)(i * maxContentSize));
                }
                byte[] bytes = new byte[length];
                dis.readFully(bytes);
                this.writeDirectMessage(new ClusterMessageFilePart().setFileId(fileId).setTotalLength(fileLength).setLastMessage(lastMessage).setData(bytes));
            }
            dis.close();
        }
        return fileId;
    }
}

