/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.rsocket;

import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.core.RSocketConnector;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.client.TcpClientTransport;
import io.rsocket.util.DefaultPayload;
import java.time.Duration;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

public class RSocketClientNode {
    private final Mono<RSocket> rSocketMono;
    private RetryBackoffSpec retrySpec;
    private String host;
    private int port;

    public RSocketClientNode(String host, int port) {
        this.host = host;
        this.port = port;
        this.retrySpec = Retry.fixedDelay((long)Long.MAX_VALUE, (Duration)Duration.ofSeconds(1L));
        this.rSocketMono = RSocketConnector.create().reconnect((Retry)this.retrySpec).connect((ClientTransport)TcpClientTransport.create((String)host, (int)port));
    }

    public void sendMessage(String msg) {
        Payload payload = (Payload)this.rSocketMono.flatMap(rSocket -> rSocket.requestResponse(DefaultPayload.create((CharSequence)msg))).retryWhen((Retry)this.retrySpec).block();
        payload.release();
    }

    public static void main(String[] args) throws InterruptedException {
        RSocketClientNode clientNode = new RSocketClientNode("localhost", 9000);
        int size = 10000000;
        for (int i = 0; i < size; ++i) {
            clientNode.sendMessage("Message " + i);
        }
    }
}

