/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.cluster.core;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.teamapps.cluster.message.protocol.ClusterServiceMethodErrorType;
import org.teamapps.message.protocol.message.Message;

public class ClusterTask {
    private static final AtomicLong taskIdGenerator = new AtomicLong();
    private final String serviceName;
    private final String method;
    private final Message request;
    private final long started;
    private final long taskId;
    private CompletableFuture<Void> completableFuture;
    private String processingNodeId;
    private int executionAttempts;
    private Message result;
    private volatile boolean error;
    private volatile boolean finished;
    private ClusterServiceMethodErrorType errorType;
    private String errorMessage;
    private String errorStackTrace;

    public ClusterTask(String serviceName, String method, Message request) {
        this.serviceName = serviceName;
        this.method = method;
        this.request = request;
        this.started = System.currentTimeMillis();
        this.taskId = taskIdGenerator.incrementAndGet();
    }

    public void startProcessing() {
        this.completableFuture = new CompletableFuture();
    }

    public Message getRequest() {
        return this.request;
    }

    public long getStarted() {
        return this.started;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void addExecutionAttempt() {
        ++this.executionAttempts;
    }

    public int getExecutionAttempts() {
        return this.executionAttempts;
    }

    public boolean isRetryLimitReached() {
        return this.executionAttempts >= 3;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getMethod() {
        return this.method;
    }

    public String getProcessingNodeId() {
        return this.processingNodeId;
    }

    public void setProcessingNodeId(String processingNodeId) {
        this.processingNodeId = processingNodeId;
    }

    public Message getResult() {
        return this.result;
    }

    public void setResult(Message result) {
        this.result = result;
        this.completableFuture.complete(null);
    }

    public void waitForResult() {
        try {
            this.completableFuture.get(90L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public ClusterServiceMethodErrorType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(ClusterServiceMethodErrorType errorType) {
        this.errorType = errorType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorStackTrace() {
        return this.errorStackTrace;
    }

    public void setErrorStackTrace(String errorStackTrace) {
        this.errorStackTrace = errorStackTrace;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }
}

