/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.common.format;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teamapps.common.format.Color;
import org.teamapps.common.format.CssStandardColors;

public class RgbaColor
implements Color {
    private static final Pattern RGBA_PATTERN = Pattern.compile("rgba\\(\\s*([\\d.]+)\\s*,\\s*([\\d.]+)\\s*,\\s*([\\d.]+)\\s*,\\s*([\\d.]+%?)\\s*\\)");
    private static final Pattern RGB_PATTERN = Pattern.compile("rgb\\(\\s*([\\d.]+)\\s*,\\s*([\\d.]+)\\s*,\\s*([\\d.]+)\\s*\\)");
    private static final Pattern HSLA_PATTERN = Pattern.compile("hsla\\(\\s*([\\d.]+)\\s*,\\s*([\\d.]+%)\\s*,\\s*([\\d.]+%)\\s*,\\s*([\\d.]+%?)\\s*\\)");
    private static final Pattern HSL_PATTERN = Pattern.compile("hsl\\(\\s*([\\d.]+)\\s*,\\s*([\\d.]+%)\\s*,\\s*([\\d.]+%)\\s*\\)");
    private final int red;
    private final int green;
    private final int blue;
    private final float alpha;

    public RgbaColor withAlpha(float alpha) {
        return new RgbaColor(this.getRed(), this.getGreen(), this.getBlue(), alpha);
    }

    public RgbaColor(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = 1.0f;
    }

    public RgbaColor(int red, int green, int blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    @Override
    public String toHtmlColorString() {
        if (this.alpha == 1.0f) {
            return "rgb(" + this.red + "," + this.green + "," + this.blue + ")";
        }
        return "rgba(" + this.red + "," + this.green + "," + this.blue + "," + this.alpha + ")";
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public float getHue() {
        return RgbaColor.rgbToHsl(this.red, this.green, this.blue)[0];
    }

    public float getSaturation() {
        return RgbaColor.rgbToHsl(this.red, this.green, this.blue)[1];
    }

    public float getLuminance() {
        return RgbaColor.rgbToHsl(this.red, this.green, this.blue)[2];
    }

    public float getAlpha() {
        return this.alpha;
    }

    public RgbaColor withBrightness(float brightnessZeroToOne) {
        float boundedBrightness = Math.max(0.0f, Math.min(brightnessZeroToOne, 1.0f));
        float[] hsb = java.awt.Color.RGBtoHSB(this.red, this.green, this.blue, null);
        return Color.fromHsba(hsb[0], hsb[1], boundedBrightness, this.alpha);
    }

    public RgbaColor withLuminance(float luminanceZeroToOne) {
        float[] hsl = RgbaColor.rgbToHsl(this.red, this.green, this.blue);
        return RgbaColor.fromHsla(hsl[0], hsl[1], luminanceZeroToOne, this.alpha);
    }

    public static float[] rgbToHsl(int red, int green, int blue) {
        float r = (float)red / 255.0f;
        float g = (float)green / 255.0f;
        float b = (float)blue / 255.0f;
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        float h = max == min ? 0.0f : (max == r ? (g - b) / (6.0f * (max - min)) : (max == g ? (b - r) / (6.0f * (max - min)) + 0.33333334f : (r - g) / (6.0f * (max - min)) + 0.6666667f));
        if (h < 0.0f) {
            h += 1.0f;
        } else if (h > 1.0f) {
            h -= 1.0f;
        }
        float l = (max + min) / 2.0f;
        float s = max == min ? 0.0f : (l <= 0.5f ? (max - min) / (max + min) : (max - min) / (2.0f - max - min));
        return new float[]{h, s, l};
    }

    public static RgbaColor fromHsla(float h, float s, float l, float alpha) {
        float q = (double)l < 0.5 ? l * (1.0f + s) : l + s - s * l;
        float p = 2.0f * l - q;
        float r = Math.min(Math.max(0.0f, RgbaColor.hueToRgbComponent(p, q, h + 0.33333334f)), 1.0f);
        float g = Math.min(Math.max(0.0f, RgbaColor.hueToRgbComponent(p, q, h)), 1.0f);
        float b = Math.min(Math.max(0.0f, RgbaColor.hueToRgbComponent(p, q, h + 0.6666667f)), 1.0f);
        return new RgbaColor(Math.round(r * 255.0f), Math.round(g * 255.0f), Math.round(b * 255.0f), alpha);
    }

    private static float hueToRgbComponent(float p, float q, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        } else if (h > 1.0f) {
            h -= 1.0f;
        }
        if (6.0f * h < 1.0f) {
            return p + (q - p) * 6.0f * h;
        }
        if (2.0f * h < 1.0f) {
            return q;
        }
        if (3.0f * h < 2.0f) {
            return p + (q - p) * 6.0f * (0.6666667f - h);
        }
        return p;
    }

    public String toString() {
        return "Color{red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", alpha=" + this.alpha + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RgbaColor color = (RgbaColor)o;
        if (this.red != color.red) {
            return false;
        }
        if (this.green != color.green) {
            return false;
        }
        if (this.blue != color.blue) {
            return false;
        }
        return Float.compare(color.alpha, this.alpha) == 0;
    }

    public int hashCode() {
        int result = this.red;
        result = 31 * result + this.green;
        result = 31 * result + this.blue;
        result = 31 * result + (this.alpha != 0.0f ? Float.floatToIntBits(this.alpha) : 0);
        return result;
    }

    public static RgbaColor fromAwtColor(java.awt.Color color) {
        return new RgbaColor(color.getRed(), color.getGreen(), color.getBlue(), (float)color.getAlpha() / 255.0f);
    }

    public static RgbaColor fromAwtColor(java.awt.Color color, float alpha) {
        return new RgbaColor(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static RgbaColor fromHsba(float h, float s, float b, float alpha) {
        int rgb = java.awt.Color.HSBtoRGB(h, s, b);
        return RgbaColor.fromRgbaValue(rgb << 8 | (int)(alpha * 255.0f) & 0xFF);
    }

    public static RgbaColor fromRgb(int red, int green, int blue) {
        return new RgbaColor(red, green, blue);
    }

    public static RgbaColor fromRgba(int red, int green, int blue, float alpha) {
        return new RgbaColor(red, green, blue, alpha);
    }

    public static RgbaColor fromRgbValue(int rgb) {
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        return new RgbaColor(r, g, b);
    }

    public static RgbaColor fromRgbaValue(int rgba) {
        int r = rgba >> 24 & 0xFF;
        int g = rgba >> 16 & 0xFF;
        int b = rgba >> 8 & 0xFF;
        float a = (float)(rgba & 0xFF) / 255.0f;
        return new RgbaColor(r, g, b, a);
    }

    public static RgbaColor fromHex(String hex) {
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        if (hex.length() == 3) {
            int r = Integer.parseInt(hex, 0, 1, 16);
            int g = Integer.parseInt(hex, 1, 2, 16);
            int b = Integer.parseInt(hex, 2, 3, 16);
            return new RgbaColor((r << 4) + r, (g << 4) + g, (b << 4) + b);
        }
        int r = Integer.parseInt(hex, 0, 2, 16);
        int g = Integer.parseInt(hex, 2, 4, 16);
        int b = Integer.parseInt(hex, 4, 6, 16);
        int a = hex.length() == 8 ? Integer.parseInt(hex, 6, 8, 16) : 255;
        return new RgbaColor(r, g, b, (float)a / 255.0f);
    }

    public static RgbaColor fromHtmlString(String value) {
        if ((value = value.trim()).startsWith("rgba")) {
            Matcher matcher = RGBA_PATTERN.matcher(value);
            if (matcher.find()) {
                int r = (int)Float.parseFloat(matcher.group(1));
                int g = (int)Float.parseFloat(matcher.group(2));
                int b = (int)Float.parseFloat(matcher.group(3));
                float a = RgbaColor.parseCssFloatingPointNumber(matcher.group(4));
                return new RgbaColor(r, g, b, a);
            }
        } else if (value.startsWith("rgb")) {
            Matcher matcher = RGB_PATTERN.matcher(value);
            if (matcher.find()) {
                int r = (int)Float.parseFloat(matcher.group(1));
                int g = (int)Float.parseFloat(matcher.group(2));
                int b = (int)Float.parseFloat(matcher.group(3));
                return new RgbaColor(r, g, b);
            }
        } else {
            Matcher matcher;
            if (value.startsWith("#")) {
                return RgbaColor.fromHex(value);
            }
            if (value.startsWith("hsla")) {
                Matcher matcher2 = HSLA_PATTERN.matcher(value);
                if (matcher2.find()) {
                    float h = Float.parseFloat(matcher2.group(1)) / 255.0f;
                    float s = RgbaColor.parseCssFloatingPointNumber(matcher2.group(2));
                    float l = RgbaColor.parseCssFloatingPointNumber(matcher2.group(3));
                    float a = RgbaColor.parseCssFloatingPointNumber(matcher2.group(4));
                    return RgbaColor.fromHsla(h, s, l, a);
                }
            } else if (value.startsWith("hsl") && (matcher = HSL_PATTERN.matcher(value)).find()) {
                float h = Float.parseFloat(matcher.group(1)) / 255.0f;
                float s = RgbaColor.parseCssFloatingPointNumber(matcher.group(2));
                float l = RgbaColor.parseCssFloatingPointNumber(matcher.group(3));
                return RgbaColor.fromHsla(h, s, l, 1.0f);
            }
        }
        return CssStandardColors.CSS_STANDARD_COLORS_BY_NAME.get(value);
    }

    private static float parseCssFloatingPointNumber(String s) {
        float a = s.endsWith("%") ? (float)Integer.parseInt(s.substring(0, s.length() - 1)) / 100.0f : Float.parseFloat(s);
        return a;
    }
}

