/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.common.util;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.common.util.RunnableWithExceptions;

public class ExceptionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private ExceptionUtil() {
    }

    public static void softenExceptions(RunnableWithExceptions runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            throw ExceptionUtil.softenedException(e);
        }
    }

    public static <V> V softenExceptions(Callable<V> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw ExceptionUtil.softenedException(e);
        }
    }

    public static <T extends RuntimeException> T softenedException(Throwable e) {
        return (T)((RuntimeException)ExceptionUtil.uncheck(e));
    }

    private static <T extends Throwable> T uncheck(Throwable throwable) throws T {
        throw throwable;
    }
}

