/*-
 * ========================LICENSE_START=================================
 * TeamApps
 * ---
 * Copyright (C) 2014 - 2020 TeamApps.org
 * ---
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
package org.teamapps.common.format;

import java.util.Map;

import static java.util.Map.entry;

public class CssStandardColors {

	public static final Map<String, RgbaColor> CSS_STANDARD_COLORS_BY_NAME = Map.ofEntries(
			entry("aliceblue", Color.ALICE_BLUE),
			entry("antiquewhite", Color.ANTIQUE_WHITE),
			entry("aqua", Color.AQUA),
			entry("aquamarine", Color.AQUA_MARINE),
			entry("azure", Color.AZURE),
			entry("beige", Color.BEIGE),
			entry("bisque", Color.BISQUE),
			entry("black", Color.BLACK),
			entry("blanchedalmond", Color.BLANCHED_ALMOND),
			entry("blue", Color.BLUE),
			entry("blueviolet", Color.BLUE_VIOLET),
			entry("brown", Color.BROWN),
			entry("burlywood", Color.BURLY_WOOD),
			entry("cadetblue", Color.CADET_BLUE),
			entry("chartreuse", Color.CHARTREUSE),
			entry("chocolate", Color.CHOCOLATE),
			entry("coral", Color.CORAL),
			entry("cornflowerblue", Color.CORN_FLOWER_BLUE),
			entry("cornsilk", Color.CORN_SILK),
			entry("crimson", Color.CRIMSON),
			entry("cyan", Color.CYAN),
			entry("darkblue", Color.DARK_BLUE),
			entry("darkcyan", Color.DARK_CYAN),
			entry("darkgoldenrod", Color.DARK_GOLDEN_ROD),
			entry("darkgray", Color.DARK_GRAY),
			entry("darkgreen", Color.DARK_GREEN),
			entry("darkgrey", Color.DARK_GREY),
			entry("darkkhaki", Color.DARK_KHAKI),
			entry("darkmagenta", Color.DARK_MAGENTA),
			entry("darkolivegreen", Color.DARK_OLIVE_GREEN),
			entry("darkorange", Color.DARK_ORANGE),
			entry("darkorchid", Color.DARK_ORCHID),
			entry("darkred", Color.DARK_RED),
			entry("darksalmon", Color.DARK_SALMON),
			entry("darkseagreen", Color.DARK_SEA_GREEN),
			entry("darkslateblue", Color.DARK_SLATE_BLUE),
			entry("darkslategray", Color.DARK_SLATE_GRAY),
			entry("darkslategrey", Color.DARK_SLATE_GREY),
			entry("darkturquoise", Color.DARK_TURQUOISE),
			entry("darkviolet", Color.DARK_VIOLET),
			entry("deeppink", Color.DEEP_PINK),
			entry("deepskyblue", Color.DEEP_SKY_BLUE),
			entry("dimgray", Color.DIMG_RAY),
			entry("dimgrey", Color.DIMG_REY),
			entry("dodgerblue", Color.DODGER_BLUE),
			entry("firebrick", Color.FIRE_BRICK),
			entry("floralwhite", Color.FLORAL_WHITE),
			entry("forestgreen", Color.FOREST_GREEN),
			entry("fuchsia", Color.FUCHSIA),
			entry("gainsboro", Color.GAINSBORO),
			entry("ghostwhite", Color.GHOST_WHITE),
			entry("gold", Color.GOLD),
			entry("goldenrod", Color.GOLDEN_ROD),
			entry("gray", Color.GRAY),
			entry("green", Color.GREEN),
			entry("greenyellow", Color.GREEN_YELLOW),
			entry("grey", Color.GREY),
			entry("honeydew", Color.HONEY_DEW),
			entry("hotpink", Color.HOT_PINK),
			entry("indianred", Color.INDIAN_RED),
			entry("indigo", Color.INDIGO),
			entry("ivory", Color.IVORY),
			entry("khaki", Color.KHAKI),
			entry("lavender", Color.LAVENDER),
			entry("lavenderblush", Color.LAVENDER_BLUSH),
			entry("lawngreen", Color.LAWN_GREEN),
			entry("lemonchiffon", Color.LEMON_CHIFFON),
			entry("lightblue", Color.LIGHT_BLUE),
			entry("lightcoral", Color.LIGHT_CORAL),
			entry("lightcyan", Color.LIGHT_CYAN),
			entry("lightgoldenrodyellow", Color.LIGHT_GOLDEN_ROD_YELLOW),
			entry("lightgray", Color.LIGHT_GRAY),
			entry("lightgreen", Color.LIGHT_GREEN),
			entry("lightgrey", Color.LIGHT_GREY),
			entry("lightpink", Color.LIGHT_PINK),
			entry("lightsalmon", Color.LIGHT_SALMON),
			entry("lightseagreen", Color.LIGHT_SEA_GREEN),
			entry("lightskyblue", Color.LIGHT_SKY_BLUE),
			entry("lightslategray", Color.LIGHT_SLATE_GRAY),
			entry("lightslategrey", Color.LIGHT_SLATE_GREY),
			entry("lightsteelblue", Color.LIGHT_STEEL_BLUE),
			entry("lightyellow", Color.LIGHT_YELLOW),
			entry("lime", Color.LIME),
			entry("limegreen", Color.LIME_GREEN),
			entry("linen", Color.LINEN),
			entry("magenta", Color.MAGENTA),
			entry("maroon", Color.MAROON),
			entry("mediumaquamarine", Color.MEDIUM_AQUA_MARINE),
			entry("mediumblue", Color.MEDIUM_BLUE),
			entry("mediumorchid", Color.MEDIUM_ORCHID),
			entry("mediumpurple", Color.MEDIUM_PURPLE),
			entry("mediumseagreen", Color.MEDIUM_SEAG_REEN),
			entry("mediumslateblue", Color.MEDIUM_SLATE_BLUE),
			entry("mediumspringgreen", Color.MEDIUM_SPRING_GREEN),
			entry("mediumturquoise", Color.MEDIUM_TURQUOISE),
			entry("mediumvioletred", Color.MEDIUM_VIOLET_RED),
			entry("midnightblue", Color.MIDNIGHT_BLUE),
			entry("mintcream", Color.MINT_CREAM),
			entry("mistyrose", Color.MISTY_ROSE),
			entry("moccasin", Color.MOCCASIN),
			entry("navajowhite", Color.NAVAJO_WHITE),
			entry("navy", Color.NAVY),
			entry("oldlace", Color.OLD_LACE),
			entry("olive", Color.OLIVE),
			entry("olivedrab", Color.OLIVE_DRAB),
			entry("orange", Color.ORANGE),
			entry("orangered", Color.ORANGE_RED),
			entry("orchid", Color.ORCHID),
			entry("palegoldenrod", Color.PALE_GOLDEN_ROD),
			entry("palegreen", Color.PALE_GREEN),
			entry("paleturquoise", Color.PALE_TURQUOISE),
			entry("palevioletred", Color.PALE_VIOLET_RED),
			entry("papayawhip", Color.PAPAYA_WHIP),
			entry("peachpuff", Color.PEACH_PUFF),
			entry("peru", Color.PERU),
			entry("pink", Color.PINK),
			entry("plum", Color.PLUM),
			entry("powderblue", Color.POWDER_BLUE),
			entry("purple", Color.PURPLE),
			entry("red", Color.RED),
			entry("rosybrown", Color.ROSY_BROWN),
			entry("royalblue", Color.ROYAL_BLUE),
			entry("saddlebrown", Color.SADDLE_BROWN),
			entry("salmon", Color.SALMON),
			entry("sandybrown", Color.SANDY_BROWN),
			entry("seagreen", Color.SEA_GREEN),
			entry("seashell", Color.SEA_SHELL),
			entry("sienna", Color.SIENNA),
			entry("silver", Color.SILVER),
			entry("skyblue", Color.SKY_BLUE),
			entry("slateblue", Color.SLATE_BLUE),
			entry("slategray", Color.SLATE_GRAY),
			entry("slategrey", Color.SLATE_GREY),
			entry("snow", Color.SNOW),
			entry("springgreen", Color.SPRING_GREEN),
			entry("steelblue", Color.STEEL_BLUE),
			entry("tan", Color.TAN),
			entry("teal", Color.TEAL),
			entry("thistle", Color.THISTLE),
			entry("tomato", Color.TOMATO),
			entry("turquoise", Color.TURQUOISE),
			entry("violet", Color.VIOLET),
			entry("wheat", Color.WHEAT),
			entry("white", Color.WHITE),
			entry("whitesmoke", Color.WHITE_SMOKE),
			entry("yellow", Color.YELLOW),
			entry("yellowgreen", Color.YELLOW_GREEN)
	);


}
