/*-
 * ========================LICENSE_START=================================
 * TeamApps Commons
 * ---
 * Copyright (C) 2022 - 2023 TeamApps.org
 * ---
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
package org.teamapps.commons.databinding;

import org.teamapps.commons.event.Event;

import java.util.Objects;
import java.util.function.Supplier;

public interface ObservableValue<T> {

	Event<T> onChange();

	T get();

	// ------- utility -------

	default boolean valueEquals(T other) {
		return Objects.equals(get(), other);
	}

	default void bindWritingTo(MutableValue<T> mutableValue) {
		DataBindings.bindOneWay(this, mutableValue);
	}


	// === static ===

	static <T> ObservableValue<T> fromEmptyEvent(Event<?> changeEvent, Supplier<T> provider) {
		return DataBindings.createObservableValueFromEmptyEvent(changeEvent, provider);
	}

	static <T> ObservableValue<T> fromEvent(Event<T> changeEvent) {
		return DataBindings.createObservableValueFromEvent(changeEvent);
	}

	static <T> ObservableValue<T> fromEvent(Event<T> changeEvent, T initialValue) {
		return DataBindings.createObservableValueFromEvent(changeEvent, initialValue);
	}

}
