/*-
 * ========================LICENSE_START=================================
 * TeamApps Commons
 * ---
 * Copyright (C) 2022 - 2023 TeamApps.org
 * ---
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
package org.teamapps.commons.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.Callable;

public class ExceptionUtil {

	private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

	private ExceptionUtil() {}

	public static void runWithSoftenedExceptions(RunnableWithExceptions runnable) {
		try {
			runnable.run();
		} catch (Exception e) {
			throw softenException(e);
		}
	}

	public static <V> V runWithSoftenedExceptions(Callable<V> callable) {
		try {
			return callable.call();
		} catch (Exception e) {
			throw softenException(e);
		}
	}

	public static <T extends RuntimeException> T softenException(final Throwable e) {
		return uncheck(e);
	}

	@SuppressWarnings("unchecked")
	private static <T extends Throwable> T uncheck(Throwable throwable) throws T {
		throw (T) throwable;
	}

	public static void systemExitOnException(RunnableWithExceptions runnable, int exitCode) {
		try {
			runnable.run();
		} catch (Exception e) {
			LOGGER.error("Will shutdown due to exception.", e);
			System.exit(exitCode);
		}
	}

}
