/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.commons.databinding;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.teamapps.commons.databinding.MutableValue;
import org.teamapps.commons.databinding.ObservableValue;
import org.teamapps.commons.databinding.TwoWayBindableValue;
import org.teamapps.commons.event.Event;

public final class DataBindings {
    public static <T> ObservableValue<T> createObservableValueFromEmptyEvent(final Event<?> changeEvent, final Supplier<T> valueSupplier) {
        return new ObservableValue<T>(){
            private final Event<T> eventWithData = new Event();
            {
                changeEvent.addListener(arg_0 -> this.lambda$new$0((Supplier)valueSupplier, arg_0));
            }

            @Override
            public Event<T> onChange() {
                return this.eventWithData;
            }

            @Override
            public T get() {
                return valueSupplier.get();
            }

            private /* synthetic */ void lambda$new$0(Supplier valueSupplier2, Object o) {
                this.eventWithData.fire(valueSupplier2.get());
            }
        };
    }

    public static <T> ObservableValue<T> createObservableValueFromEvent(Event<T> event) {
        return DataBindings.createObservableValueFromEvent(event, null);
    }

    public static <T> ObservableValue<T> createObservableValueFromEvent(final Event<T> event, final T initialValue) {
        return new ObservableValue<T>(){
            private T lastSeenValue;
            {
                this.lastSeenValue = initialValue;
                event.addListener(t -> {
                    this.lastSeenValue = t;
                });
            }

            @Override
            public Event<T> onChange() {
                return event;
            }

            @Override
            public T get() {
                return this.lastSeenValue;
            }
        };
    }

    public static <T> MutableValue<T> createMutableValue(Consumer<T> consumer) {
        return consumer::accept;
    }

    public static <T> void bindOneWay(ObservableValue<T> observableValue, MutableValue<T> mutableValue) {
        mutableValue.set(observableValue.get());
        observableValue.onChange().addListener(value -> mutableValue.set(observableValue.get()));
    }

    public static <T> void bindTwoWays(TwoWayBindableValue<T> bindable1, TwoWayBindableValue<T> bindable2) {
        LoopInterruptingConsumerBuilder consumerBuilder = new LoopInterruptingConsumerBuilder();
        bindable1.onChange().addListener(consumerBuilder.create(aVoid -> bindable2.set(bindable1.get())));
        bindable2.onChange().addListener(consumerBuilder.create(aVoid -> bindable1.set(bindable2.get())));
        bindable2.set(bindable1.get());
    }

    static class LoopInterruptingConsumerBuilder {
        private final ThreadLocal<Boolean> processing = new ThreadLocal();

        LoopInterruptingConsumerBuilder() {
        }

        public <EVENT_DATA> Consumer<EVENT_DATA> create(Consumer<EVENT_DATA> handler) {
            return eventData -> {
                if (!this.isAlreadyProcessing()) {
                    this.processing.set(true);
                    try {
                        handler.accept(eventData);
                    }
                    finally {
                        this.processing.set(false);
                    }
                }
            };
        }

        private boolean isAlreadyProcessing() {
            return this.processing.get() != null && this.processing.get() != false;
        }
    }
}

