/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.commons.databinding;

import java.util.Objects;
import java.util.function.Supplier;
import org.teamapps.commons.databinding.DataBindings;
import org.teamapps.commons.databinding.MutableValue;
import org.teamapps.commons.event.Event;

public interface ObservableValue<T> {
    public Event<T> onChange();

    public T get();

    default public boolean valueEquals(T other) {
        return Objects.equals(this.get(), other);
    }

    default public void bindWritingTo(MutableValue<T> mutableValue) {
        DataBindings.bindOneWay(this, mutableValue);
    }

    public static <T> ObservableValue<T> fromEmptyEvent(Event<?> changeEvent, Supplier<T> provider) {
        return DataBindings.createObservableValueFromEmptyEvent(changeEvent, provider);
    }

    public static <T> ObservableValue<T> fromEvent(Event<T> changeEvent) {
        return DataBindings.createObservableValueFromEvent(changeEvent);
    }

    public static <T> ObservableValue<T> fromEvent(Event<T> changeEvent, T initialValue) {
        return DataBindings.createObservableValueFromEvent(changeEvent, initialValue);
    }
}

