/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.commons.event;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.commons.event.Disposable;
import org.teamapps.commons.event.EventListenerRegistrationStatusListener;
import org.teamapps.commons.event.SelfDisposingEventListener;

public class Event<EVENT_DATA> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Event.class);
    private final String source;
    protected final List<Consumer<EVENT_DATA>> listeners = new CopyOnWriteArrayList<Consumer<EVENT_DATA>>();
    private final EventListenerRegistrationStatusListener registrationListener;
    private EVENT_DATA lastEventData;

    public Event() {
        this(null);
    }

    public Event(EventListenerRegistrationStatusListener registrationListener) {
        this.registrationListener = registrationListener;
        StackTraceElement stackTraceElement = new Exception().getStackTrace()[1];
        this.source = stackTraceElement.getFileName() + stackTraceElement.getLineNumber();
    }

    public Disposable addListener(Consumer<EVENT_DATA> listener) {
        boolean wasEmpty = this.listeners.isEmpty();
        this.listeners.add(listener);
        if (this.registrationListener != null && wasEmpty) {
            this.registrationListener.listeningStatusChanged(true);
        }
        return () -> {
            boolean wasRemoved = this.listeners.remove(listener);
            if (this.registrationListener != null && wasRemoved && this.listeners.isEmpty()) {
                this.registrationListener.listeningStatusChanged(false);
            }
        };
    }

    public Disposable addListener(SelfDisposingEventListener<EVENT_DATA> listener) {
        AtomicReference<Disposable> disposable = new AtomicReference<Disposable>();
        disposable.set(this.addListener((EVENT_DATA e) -> listener.handle(e, (Disposable)disposable.get())));
        return (Disposable)disposable.get();
    }

    public Disposable addListener(Runnable listener) {
        return this.addListener(new RunnableWrapper(listener));
    }

    public List<Consumer<EVENT_DATA>> getListeners() {
        return this.listeners;
    }

    public void fire(EVENT_DATA eventData) {
        this.lastEventData = eventData;
        for (Consumer<EVENT_DATA> listener : this.listeners) {
            this.invokeListener(eventData, listener);
        }
    }

    public void fireIgnoringExceptions(EVENT_DATA eventData) {
        this.lastEventData = eventData;
        for (Consumer<EVENT_DATA> listener : this.listeners) {
            try {
                this.invokeListener(eventData, listener);
            }
            catch (Exception e) {
                LOGGER.error("Error while calling event handler. Ignoring exception.", (Throwable)e);
            }
        }
    }

    protected void invokeListener(EVENT_DATA eventData, Consumer<EVENT_DATA> listener) {
        listener.accept(eventData);
    }

    public void fireIfChanged(EVENT_DATA eventData) {
        if (!Objects.equals(this.lastEventData, eventData)) {
            this.fire(eventData);
        }
    }

    public <T> Event<T> converted(Function<EVENT_DATA, T> converter) {
        Event newEvent = new Event();
        this.addListener((EVENT_DATA data) -> newEvent.fire(converter.apply(data)));
        return newEvent;
    }

    public void fire() {
        this.fire(null);
    }

    protected static class RunnableWrapper<T>
    implements Consumer<T> {
        private final Runnable runnable;

        public RunnableWrapper(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void accept(T eventData) {
            this.runnable.run();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RunnableWrapper that = (RunnableWrapper)o;
            return this.runnable.equals(that.runnable);
        }

        public int hashCode() {
            return Objects.hash(this.runnable);
        }
    }
}

