/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.commons.formatter;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import org.teamapps.commons.formatter.FileSizeFormatter;

public class LocalizedFormatter {
    private final Locale locale;
    private final ZoneId timezone;
    private final NumberFormat percentFormat;
    private final NumberFormat compactNumberFormat;
    private final NumberFormat decimalFormat;
    private final DateTimeFormatter dateTimeFormat;
    private final DateTimeFormatter dateTimeFormatLong;
    private final DateTimeFormatter timeFormatter;
    private final DateTimeFormatter durationFormatter;

    public LocalizedFormatter() {
        this(Locale.getDefault(), ZoneId.systemDefault());
    }

    public LocalizedFormatter(Locale locale, ZoneId timezone) {
        this.locale = locale;
        this.timezone = timezone;
        this.percentFormat = NumberFormat.getPercentInstance(locale);
        this.percentFormat.setMaximumFractionDigits(2);
        this.compactNumberFormat = NumberFormat.getCompactNumberInstance(locale, NumberFormat.Style.LONG);
        this.decimalFormat = DecimalFormat.getInstance(locale);
        this.decimalFormat.setMaximumFractionDigits(2);
        this.dateTimeFormat = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.SHORT).withLocale(locale);
        this.dateTimeFormatLong = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL, FormatStyle.SHORT).withLocale(locale);
        this.timeFormatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).withLocale(locale);
        this.durationFormatter = DateTimeFormatter.ofPattern("mm:ss");
    }

    public String fileSize(long length) {
        return FileSizeFormatter.humanReadableByteCount(length, false, 0);
    }

    public String percent(double value) {
        return this.percentFormat.format(value);
    }

    public String decimalNumber(double value) {
        return this.decimalFormat.format(value);
    }

    public String compactNumber(long value) {
        return this.compactNumberFormat.format(value);
    }

    public String timestamp(int timestamp) {
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(timestamp), this.timezone).format(this.dateTimeFormat);
    }

    public String timestamp(long timestamp) {
        if (timestamp < Integer.MAX_VALUE) {
            return ZonedDateTime.ofInstant(Instant.ofEpochSecond(timestamp), this.timezone).format(this.dateTimeFormat);
        }
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), this.timezone).format(this.dateTimeFormat);
    }

    public String timestampLong(int timestamp) {
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(timestamp), this.timezone).format(this.dateTimeFormatLong);
    }

    public String timestampLong(long timestamp) {
        if (timestamp < Integer.MAX_VALUE) {
            return ZonedDateTime.ofInstant(Instant.ofEpochSecond(timestamp), this.timezone).format(this.dateTimeFormatLong);
        }
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), this.timezone).format(this.dateTimeFormatLong);
    }

    public String timeOnly(Instant instant) {
        return ZonedDateTime.ofInstant(instant, this.timezone).format(this.timeFormatter);
    }

    public String durationInSeconds(int seconds) {
        LocalTime timeOfDay = LocalTime.ofSecondOfDay(seconds);
        return this.durationFormatter.format(timeOfDay);
    }
}

