/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.commons.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import org.teamapps.commons.util.ExceptionUtil;

public class ClassPathResourceUtil {
    private ClassPathResourceUtil() {
    }

    public static String readResourceToString(String resourceName) {
        InputStream is = ClassPathResourceUtil.getResourceAsStream(resourceName);
        if (is != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            return reader.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        throw new IllegalArgumentException("Could not find resource: " + resourceName);
    }

    public static InputStream getResourceAsStream(String resourceName) {
        InputStream is = ClassPathResourceUtil.class.getClassLoader().getResourceAsStream(resourceName);
        if (is == null) {
            is = ClassLoader.getSystemResourceAsStream(resourceName);
        }
        return is;
    }

    public static byte[] readResourceToByteArray(String resourceName) {
        return ClassPathResourceUtil.readInputStreamToByteArray(ClassPathResourceUtil.getResourceAsStream(resourceName));
    }

    public static byte[] readInputStreamToByteArray(InputStream is) {
        return ExceptionUtil.runWithSoftenedExceptions(() -> {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            is.transferTo(buffer);
            return buffer.toByteArray();
        });
    }
}

