/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.commons.util;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.commons.util.RunnableWithExceptions;

public class ExceptionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private ExceptionUtil() {
    }

    public static void runWithSoftenedExceptions(RunnableWithExceptions runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            throw ExceptionUtil.softenException(e);
        }
    }

    public static <V> V runWithSoftenedExceptions(Callable<V> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw ExceptionUtil.softenException(e);
        }
    }

    public static <T extends RuntimeException> T softenException(Throwable e) {
        return (T)((RuntimeException)ExceptionUtil.uncheck(e));
    }

    private static <T extends Throwable> T uncheck(Throwable throwable) throws T {
        throw throwable;
    }

    public static void systemExitOnException(RunnableWithExceptions runnable, int exitCode) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            LOGGER.error("Will shutdown due to exception.", (Throwable)e);
            System.exit(exitCode);
        }
    }
}

