/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.commons.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ReflectionUtil {
    public static List<Field> findFields(Class<?> clazz, Predicate<Field> predicate) {
        ArrayList<Field> matchingFields = new ArrayList<Field>();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!predicate.test(field)) continue;
                matchingFields.add(field);
            }
        }
        return matchingFields;
    }

    public static Field findField(Class<?> clazz, Predicate<Field> predicate) {
        List<Field> fields = ReflectionUtil.findFields(clazz, predicate);
        return fields.size() > 0 ? fields.get(0) : null;
    }

    public static Field findField(Class<?> clazz, String fieldName) {
        return ReflectionUtil.findField(clazz, (Field field) -> field.getName().equals(fieldName));
    }

    public static List<Method> findMethods(Class<?> clazz, Predicate<Method> predicate) {
        ArrayList<Method> matchingMethods = new ArrayList<Method>();
        List<Class<?>> hierarchy = ReflectionUtil.getAllExtendedOrImplementedTypesRecursively(clazz);
        for (Class<?> c : hierarchy) {
            for (Method method : c.getDeclaredMethods()) {
                if (!predicate.test(method)) continue;
                matchingMethods.add(method);
            }
        }
        return matchingMethods;
    }

    public static List<Class<?>> getAllExtendedOrImplementedTypesRecursively(Class<?> clazz) {
        ArrayList res = new ArrayList();
        do {
            Class<?>[] interfaces;
            res.add(clazz);
            for (Class<?> interf : interfaces = clazz.getInterfaces()) {
                res.add(interf);
                res.addAll(ReflectionUtil.getAllExtendedOrImplementedTypesRecursively(interf));
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return res.stream().distinct().collect(Collectors.toList());
    }

    public static Method findMethod(Class<?> clazz, Predicate<Method> predicate) {
        List<Method> methods = ReflectionUtil.findMethods(clazz, predicate);
        return methods.size() > 0 ? methods.get(0) : null;
    }

    public static Method findMethod(Class<?> clazz, String methodName) {
        return ReflectionUtil.findMethod(clazz, (Method method) -> method.getName().equals(methodName));
    }

    public static Method findMethodByName(Class<?> clazz, String methodName) {
        return ReflectionUtil.findMethod(clazz, (Method method) -> method.getName().equals(methodName));
    }

    public static <RECORD> Object invokeMethod(RECORD object, Method method, Object ... parameters) {
        try {
            return method.invoke(object, parameters);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Exception while invoking method " + method.getName(), e);
        }
        catch (IllegalArgumentException e) {
            String expectedParameterTypesString = Arrays.stream(method.getParameterTypes()).map(paramClass -> paramClass.getSimpleName()).collect(Collectors.joining(", "));
            String actualParameterTypesString = Arrays.stream(parameters).map(p -> p == null ? "null" : p.getClass().getSimpleName()).collect(Collectors.joining(", "));
            throw new IllegalArgumentException("Could not invoke method " + method.getName() + "(" + expectedParameterTypesString + ") with given parameter types: " + actualParameterTypesString, e);
        }
    }

    public static Object readField(Object object, Field field, boolean makeAccessibleIfNecessary) {
        try {
            if (makeAccessibleIfNecessary && !field.canAccess(object)) {
                field.setAccessible(true);
            }
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void readField(Object object, String fieldName, boolean makeAccessibleIfNecessary) {
        Field field = ReflectionUtil.findField(object.getClass(), fieldName);
        ReflectionUtil.readField(object, field, makeAccessibleIfNecessary);
    }

    public static void setField(Object object, Field field, Object value, boolean makeAccessibleIfNecessary) {
        try {
            if (makeAccessibleIfNecessary && !field.canAccess(object)) {
                field.setAccessible(true);
            }
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setField(Object object, String fieldName, Object value, boolean makeAccessibleIfNecessary) {
        Field field = ReflectionUtil.findField(object.getClass(), fieldName);
        ReflectionUtil.setField(object, field, value, makeAccessibleIfNecessary);
    }
}

