/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.commons.util.collections;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.teamapps.commons.util.collections.Pair;

public final class ByKeyComparisonResult<A, B, K> {
    private final List<A> aEntriesNotInB;
    private final List<A> aEntriesInB;
    private final List<B> bEntriesNotInA;
    private final List<B> bEntriesInA;
    private final Map<K, A> aByKey;
    private final Map<K, B> bByKey;
    private final Function<A, K> keyExtractorA;
    private final Function<B, K> keyExtractorB;

    public ByKeyComparisonResult(List<A> aEntriesNotInB, List<A> aEntriesInB, List<B> bEntriesNotInA, List<B> bEntriesInA, Map<K, A> aByKey, Map<K, B> bByKey, Function<A, K> keyExtractorA, Function<B, K> keyExtractorB) {
        this.aEntriesNotInB = aEntriesNotInB;
        this.aEntriesInB = aEntriesInB;
        this.bEntriesNotInA = bEntriesNotInA;
        this.bEntriesInA = bEntriesInA;
        this.aByKey = aByKey;
        this.bByKey = bByKey;
        this.keyExtractorA = keyExtractorA;
        this.keyExtractorB = keyExtractorB;
    }

    public A getA(B b) {
        return this.aByKey.get(this.keyExtractorB.apply(b));
    }

    public B getB(A a) {
        return this.bByKey.get(this.keyExtractorA.apply(a));
    }

    public List<A> getAEntriesNotInB() {
        return this.aEntriesNotInB;
    }

    public List<A> getAEntriesInB() {
        return this.aEntriesInB;
    }

    public List<B> getBEntriesNotInA() {
        return this.bEntriesNotInA;
    }

    public List<B> getBEntriesInA() {
        return this.bEntriesInA;
    }

    public List<Pair<A, B>> getPairs() {
        return this.aEntriesInB.stream().map(a -> new Pair<Object, B>(a, this.getB(a))).toList();
    }

    public void forEachExisting(BiConsumer<A, B> sameKeyConsumer) {
        for (A a : this.aEntriesInB) {
            B b = this.getB(a);
            sameKeyConsumer.accept(a, b);
        }
    }

    public void forEachNew(Consumer<B> newKeyConsumer) {
        for (B b : this.bEntriesNotInA) {
            newKeyConsumer.accept(b);
        }
    }

    public void forEachRemoved(Consumer<A> removedKeyConsumer) {
        for (A a : this.aEntriesNotInB) {
            removedKeyConsumer.accept(a);
        }
    }

    public boolean isDifferent() {
        return !this.bEntriesNotInA.isEmpty() || !this.aEntriesNotInB.isEmpty();
    }
}

