/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.commons.util.collections;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.commons.util.collections.ByKeyComparisonResult;

public class CollectionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static <A, B, K> ByKeyComparisonResult<A, B, K> compareByKey(Collection<A> collectionA, Collection<B> collectionB, Function<A, K> keyExtractorA, Function<B, K> keyExtractorB) {
        return CollectionUtil.compareByKey(collectionA, collectionB, keyExtractorA, keyExtractorB, false);
    }

    public static <A, B, K> ByKeyComparisonResult<A, B, K> compareByKey(Collection<A> collectionA, Collection<B> collectionB, Function<A, K> keyExtractorA, Function<B, K> keyExtractorB, boolean enforceUniqueKeys) {
        Map<K, Object> bByKey;
        Map<K, Object> aByKey;
        ArrayList<A> aEntriesNotInB = new ArrayList<A>();
        ArrayList<A> aEntriesInB = new ArrayList<A>();
        ArrayList<Object> bEntriesNotInA = new ArrayList<Object>();
        ArrayList<Object> bEntriesInA = new ArrayList<Object>();
        if (enforceUniqueKeys) {
            aByKey = collectionA.stream().collect(Collectors.toMap(keyExtractorA, a -> a));
            bByKey = collectionB.stream().collect(Collectors.toMap(keyExtractorB, b -> b));
        } else {
            aByKey = collectionA.stream().collect(Collectors.toMap(keyExtractorA, a -> a, (key1, key2) -> {
                LOGGER.warn("collectionA contains entries with non-unique key \"" + String.valueOf(keyExtractorA.apply(key1)) + "\": " + String.valueOf(key1) + ", " + String.valueOf(key2));
                return key1;
            }));
            bByKey = collectionB.stream().collect(Collectors.toMap(keyExtractorB, b -> b, (key1, key2) -> {
                LOGGER.warn("collectionB contains entries with non-unique key \"" + String.valueOf(keyExtractorB.apply(key1)) + "\": " + String.valueOf(key1) + ", " + String.valueOf(key2));
                return key1;
            }));
        }
        for (A a2 : collectionA) {
            if (bByKey.containsKey(keyExtractorA.apply(a2))) {
                aEntriesInB.add(a2);
                continue;
            }
            aEntriesNotInB.add(a2);
        }
        for (Object b2 : collectionB) {
            if (aByKey.containsKey(keyExtractorB.apply(b2))) {
                bEntriesInA.add(b2);
                continue;
            }
            bEntriesNotInA.add(b2);
        }
        return new ByKeyComparisonResult<Object, Object, K>(aEntriesNotInB, aEntriesInB, bEntriesNotInA, bEntriesInA, aByKey, bByKey, keyExtractorA, keyExtractorB);
    }
}

