/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.configuration;

import java.util.ArrayList;
import java.util.List;

public class ConfigKeyOverride {
    private final String service;
    private final List<String> path = new ArrayList<String>();
    private final String key;
    private final String value;

    public static boolean checkKey(String rawKey, boolean environmentVariable) {
        return rawKey != null && !rawKey.isBlank() && ConfigKeyOverride.split(rawKey, environmentVariable).length > 1;
    }

    public ConfigKeyOverride(String rawKey, String value, boolean environmentVariable) {
        String[] parts = ConfigKeyOverride.split(rawKey, environmentVariable);
        this.service = parts[0];
        this.key = parts[parts.length - 1];
        this.value = value;
        if (parts.length > 2) {
            for (int i = 1; i < parts.length - 2; ++i) {
                this.path.add(parts[i]);
            }
        }
    }

    private static String[] split(String rawKey, boolean environmentVariable) {
        if (environmentVariable) {
            return rawKey.toLowerCase().split("__");
        }
        return rawKey.toLowerCase().split("\\.");
    }

    public boolean withPath() {
        return !this.path.isEmpty();
    }

    public String getService() {
        return this.service;
    }

    public List<String> getPath() {
        return this.path;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }
}

