/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.configuration;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.teamapps.configuration.ConfigKeyOverride;
import org.teamapps.configuration.ConfigUpdateConsumer;
import org.teamapps.message.protocol.message.AttributeType;
import org.teamapps.message.protocol.message.Message;
import org.teamapps.message.protocol.message.MessageRecord;
import org.teamapps.message.protocol.model.AttributeDefinition;
import org.teamapps.message.protocol.model.PojoObjectDecoder;
import org.teamapps.message.protocol.utils.StringUtils;

public class Configuration {
    private static Configuration instance;
    private final Map<String, List<ConfigKeyOverride>> overridesMap = new HashMap<String, List<ConfigKeyOverride>>();
    private final Map<String, List<ConfigUpdateConsumer<?>>> listenerMap = new HashMap();
    private final Map<String, Message> configCache = Collections.synchronizedMap(new HashMap());
    private File configPath = new File("./config/");

    public static synchronized Configuration getConfiguration() {
        if (instance == null) {
            instance = new Configuration(null);
        }
        return instance;
    }

    public static synchronized Configuration getConfiguration(String[] args) {
        if (instance == null) {
            instance = new Configuration(args);
            return instance;
        }
        return instance;
    }

    private Configuration(String[] args) {
        this.init(args);
    }

    private void init(String[] args) {
        String customPath;
        List<ConfigKeyOverride> teamappsKeys;
        System.getenv().entrySet().stream().filter(entry -> ConfigKeyOverride.checkKey((String)entry.getKey(), true)).map(entry -> new ConfigKeyOverride((String)entry.getKey(), (String)entry.getValue(), true)).forEach(configKeyOverride -> this.overridesMap.computeIfAbsent(configKeyOverride.getService().toLowerCase(), s -> new ArrayList()).add(configKeyOverride));
        if (args != null) {
            for (String arg : args) {
                int pos = arg.indexOf(61);
                if (pos <= 0) continue;
                String key2 = arg.substring(0, pos).replace("-", "").trim();
                String value = arg.substring(pos + 1).trim();
                if (!ConfigKeyOverride.checkKey(key2, false)) continue;
                ConfigKeyOverride configKeyOverride2 = new ConfigKeyOverride(key2, value, false);
                this.overridesMap.computeIfAbsent(configKeyOverride2.getService().toLowerCase(), s -> new ArrayList()).add(configKeyOverride2);
            }
        }
        if ((teamappsKeys = this.overridesMap.get("teamapps")) != null && (customPath = (String)teamappsKeys.stream().filter(key -> key.getKey().equals("configpath")).filter(key -> !key.withPath()).map(ConfigKeyOverride::getValue).findAny().orElse(null)) != null) {
            this.configPath = new File(customPath);
        }
    }

    private <CONFIG extends Message> CONFIG readConfig(String serviceName, PojoObjectDecoder<CONFIG> decoder) throws IOException {
        return this.readConfig(this.configPath, serviceName, decoder);
    }

    private <CONFIG extends Message> CONFIG readConfig(File path, String serviceName, PojoObjectDecoder<CONFIG> decoder) throws IOException {
        File configFile = new File(path, serviceName.toLowerCase() + ".xml");
        return Configuration.readConfig(configFile, decoder);
    }

    private static <CONFIG extends Message> CONFIG readConfig(File configFile, PojoObjectDecoder<CONFIG> decoder) throws IOException {
        Message config;
        if (configFile.exists()) {
            String xml = Files.readString(configFile.toPath(), StandardCharsets.UTF_8);
            config = (Message)decoder.decode(xml, null);
        } else {
            config = (Message)decoder.defaultMessage();
            Configuration.writeConfig(configFile, config);
        }
        return (CONFIG)config;
    }

    private static <CONFIG extends Message> void writeConfig(File configFile, CONFIG config) throws IOException {
        if (!configFile.getParentFile().exists()) {
            configFile.getParentFile().mkdir();
        }
        String xml = config.toXml();
        Files.writeString(configFile.toPath(), (CharSequence)xml, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private void handleConfigUpdate(String serviceName, Message message) {
        List<ConfigUpdateConsumer<?>> updateConsumerList = this.listenerMap.get(serviceName);
        if (updateConsumerList != null) {
            for (ConfigUpdateConsumer<?> configUpdateConsumer : updateConsumerList) {
                new Thread(() -> configUpdateConsumer.handleUpdate(message)).start();
            }
        }
    }

    private <CONFIG extends Message> CONFIG initServiceConfig(String serviceName, PojoObjectDecoder<CONFIG> decoder) throws IOException {
        CONFIG config = this.readConfig(serviceName, decoder);
        List<ConfigKeyOverride> configKeyOverrides = this.overridesMap.get(serviceName.toLowerCase());
        if (configKeyOverrides != null) {
            for (ConfigKeyOverride keyOverride : configKeyOverrides) {
                AttributeDefinition attributeDefinition;
                String key = keyOverride.getKey();
                List<String> path = keyOverride.getPath();
                if (!path.isEmpty() || (attributeDefinition = (AttributeDefinition)config.getModel().getAttributeDefinitions().stream().filter(def -> def.getName().equalsIgnoreCase(key)).findAny().orElse(null)) == null) continue;
                config.setAttribute(attributeDefinition.getName(), StringUtils.readFromString((String)keyOverride.getValue(), (AttributeType)attributeDefinition.getType()));
            }
        }
        return config;
    }

    public <CONFIG extends Message> CONFIG getConfig(String serviceName, PojoObjectDecoder<CONFIG> decoder) {
        try {
            Object message = this.configCache.get(serviceName.toLowerCase());
            if (message == null) {
                message = this.initServiceConfig(serviceName, decoder);
                this.configCache.put(serviceName.toLowerCase(), (Message)message);
            }
            return (CONFIG)((Message)decoder.remap((MessageRecord)message));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <CONFIG extends Message> void addConfigUpdateListener(Consumer<CONFIG> updateConsumer, String serviceName, PojoObjectDecoder<CONFIG> decoder) {
        this.listenerMap.computeIfAbsent(serviceName.toLowerCase(), s -> new CopyOnWriteArrayList()).add(new ConfigUpdateConsumer<CONFIG>(updateConsumer, serviceName, decoder));
    }
}

