package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbGroupFolderQuery extends AbstractUdbQuery<GroupFolder> implements GroupFolderQuery {

    public UdbGroupFolderQuery() {
        super(UdbGroupFolder.table, GroupFolder.getBuilder());
    }

    @Override
    public GroupFolderQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public GroupFolderQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public GroupFolderQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public GroupFolderQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbGroupFolder.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public GroupFolderQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbGroupFolder.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public GroupFolderQuery metaCreationDate(NumericFilter filter) {
		and(UdbGroupFolder.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbGroupFolder.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery metaCreatedBy(NumericFilter filter) {
		and(UdbGroupFolder.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbGroupFolder.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery metaModificationDate(NumericFilter filter) {
		and(UdbGroupFolder.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbGroupFolder.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery metaModifiedBy(NumericFilter filter) {
		and(UdbGroupFolder.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbGroupFolder.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery metaDeletionDate(NumericFilter filter) {
		and(UdbGroupFolder.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbGroupFolder.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery metaDeletedBy(NumericFilter filter) {
		and(UdbGroupFolder.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbGroupFolder.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery metaRestoreDate(NumericFilter filter) {
		and(UdbGroupFolder.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbGroupFolder.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery metaRestoredBy(NumericFilter filter) {
		and(UdbGroupFolder.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbGroupFolder.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery filterGroup(GroupQuery query) {
		UdbGroupQuery udbQuery = (UdbGroupQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbGroupFolder.group, UdbGroup.groupFolders);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public GroupFolderQuery group(NumericFilter filter) {
		and(UdbGroupFolder.group.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery orGroup(NumericFilter filter) {
		or(UdbGroupFolder.group.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery name(TextFilter filter) {
		and(UdbGroupFolder.name.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery orName(TextFilter filter) {
		or(UdbGroupFolder.name.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery moderatorReadAccess(BooleanFilter filter) {
		and(UdbGroupFolder.moderatorReadAccess.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery orModeratorReadAccess(BooleanFilter filter) {
		or(UdbGroupFolder.moderatorReadAccess.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery moderatorWriteAccess(BooleanFilter filter) {
		and(UdbGroupFolder.moderatorWriteAccess.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery orModeratorWriteAccess(BooleanFilter filter) {
		or(UdbGroupFolder.moderatorWriteAccess.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery subjectTags(TextFilter filter) {
		and(UdbGroupFolder.subjectTags.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery orSubjectTags(TextFilter filter) {
		or(UdbGroupFolder.subjectTags.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery groupFolderType(EnumFilterType filterType, GroupFolderType... enums) {
		and(UdbGroupFolder.groupFolderType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public GroupFolderQuery orGroupFolderType(EnumFilterType filterType, GroupFolderType... enums) {
		or(UdbGroupFolder.groupFolderType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public GroupFolderQuery filterMessages(MessageQuery query) {
		UdbMessageQuery udbQuery = (UdbMessageQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbGroupFolder.messages, UdbMessage.groupFolder);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public GroupFolderQuery messages(MultiReferenceFilterType type, Message ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (Message value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbGroupFolder.messages.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery messagesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbGroupFolder.messages.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery messages(MultiReferenceFilter filter) {
		and(UdbGroupFolder.messages.createFilter(filter));
		return this;
	}

	@Override
	public GroupFolderQuery orMessages(MultiReferenceFilter filter) {
		or(UdbGroupFolder.messages.createFilter(filter));
		return this;
	}


	@Override
	public UdbGroupFolderQuery andOr(GroupFolderQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public GroupFolderQuery customFilter(Function<GroupFolder, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(GroupFolder.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



