package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbOrganizationUnitType extends AbstractUdbEntity<OrganizationUnitType> implements OrganizationUnitType {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static TranslatableTextIndex name;
	protected static TranslatableTextIndex abbreviation;
	protected static TextIndex icon;
	protected static BooleanIndex translateOrganizationUnits;
	protected static BooleanIndex allowUsers;
	protected static SingleReferenceIndex defaultChildType;
	protected static MultiReferenceIndex possibleChildrenTypes;
	protected static ShortIndex geoLocationType;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORED_BY);
		name = (TranslatableTextIndex) tableIndex.getColumnIndex(FIELD_NAME);
		abbreviation = (TranslatableTextIndex) tableIndex.getColumnIndex(FIELD_ABBREVIATION);
		icon = (TextIndex) tableIndex.getColumnIndex(FIELD_ICON);
		translateOrganizationUnits = (BooleanIndex) tableIndex.getColumnIndex(FIELD_TRANSLATE_ORGANIZATION_UNITS);
		allowUsers = (BooleanIndex) tableIndex.getColumnIndex(FIELD_ALLOW_USERS);
		defaultChildType = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_DEFAULT_CHILD_TYPE);
		possibleChildrenTypes = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_POSSIBLE_CHILDREN_TYPES);
		geoLocationType = (ShortIndex) tableIndex.getColumnIndex(FIELD_GEO_LOCATION_TYPE);
    }

    public static List<OrganizationUnitType> getAll() {
        return new EntityBitSetList<>(OrganizationUnitType.getBuilder(), table.getRecordBitSet());
    }

    public static List<OrganizationUnitType> getDeletedRecords() {
        return new EntityBitSetList<>(OrganizationUnitType.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<OrganizationUnitType> sort(List<OrganizationUnitType> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<OrganizationUnitType> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, OrganizationUnitType.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbOrganizationUnitType() {
        super(table);
    }

    public UdbOrganizationUnitType(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public OrganizationUnitType build() {
        return new UdbOrganizationUnitType();
    }

    @Override
    public OrganizationUnitType build(int id) {
        return new UdbOrganizationUnitType(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public OrganizationUnitType setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public OrganizationUnitType setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public OrganizationUnitType setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public OrganizationUnitType setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public OrganizationUnitType setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public OrganizationUnitType setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public OrganizationUnitType setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public OrganizationUnitType setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public OrganizationUnitType setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public OrganizationUnitType setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public OrganizationUnitType setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public OrganizationUnitType setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public OrganizationUnitType setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public OrganizationUnitType setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public OrganizationUnitType setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public OrganizationUnitType setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public TranslatableText getName() {
	    return getTranslatableTextValue(this.name);
	}

	@Override
	public OrganizationUnitType setName(TranslatableText value) {
    	setTranslatableTextValue(value, this.name);
		return this;
	}

	@Override
	public TranslatableText getAbbreviation() {
	    return getTranslatableTextValue(this.abbreviation);
	}

	@Override
	public OrganizationUnitType setAbbreviation(TranslatableText value) {
    	setTranslatableTextValue(value, this.abbreviation);
		return this;
	}

	@Override
	public String getIcon() {
        return getTextValue(icon);
	}

	@Override
	public OrganizationUnitType setIcon(String value) {
	    setTextValue(value, this.icon);
		return this;
	}

	@Override
	public boolean getTranslateOrganizationUnits() {
	    return getBooleanValue(translateOrganizationUnits);
	}

	@Override
	public OrganizationUnitType setTranslateOrganizationUnits(boolean value) {
	    setBooleanValue(value, this.translateOrganizationUnits);
		return this;
	}

	@Override
	public boolean isTranslateOrganizationUnits() {
	    return getBooleanValue(translateOrganizationUnits);
	}

	@Override
	public boolean getAllowUsers() {
	    return getBooleanValue(allowUsers);
	}

	@Override
	public OrganizationUnitType setAllowUsers(boolean value) {
	    setBooleanValue(value, this.allowUsers);
		return this;
	}

	@Override
	public boolean isAllowUsers() {
	    return getBooleanValue(allowUsers);
	}

	@Override
	public OrganizationUnitType getDefaultChildType() {
		if (isChanged(defaultChildType)) {
			return (OrganizationUnitType) getReferenceChangeValue(defaultChildType);
		} else {
			int id = defaultChildType.getValue(getId());
			if (id > 0) {
				return OrganizationUnitType.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public OrganizationUnitType setDefaultChildType(OrganizationUnitType value) {
		setSingleReferenceValue(defaultChildType, value, table);
		return this;
	}

	@Override
	public List<OrganizationUnitType> getPossibleChildrenTypes() {
	    return getMultiReferenceValue(possibleChildrenTypes, OrganizationUnitType.getBuilder());
	}

	@Override
	public OrganizationUnitType setPossibleChildrenTypes(List<OrganizationUnitType> value) {
		setMultiReferenceValue(value, possibleChildrenTypes);
		return this;
	}

	@Override
	public int getPossibleChildrenTypesCount() {
	    return getMultiReferenceValueCount(possibleChildrenTypes, OrganizationUnitType.getBuilder());
	}

	@Override
	public OrganizationUnitType setPossibleChildrenTypes(OrganizationUnitType ... value) {
		setMultiReferenceValue(Arrays.asList(value), possibleChildrenTypes);
		return this;
	}

	@Override
	public BitSet getPossibleChildrenTypesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(possibleChildrenTypes, OrganizationUnitType.getBuilder());
	}

	@Override
	public OrganizationUnitType addPossibleChildrenTypes(List<OrganizationUnitType> value) {
		addMultiReferenceValue(value, possibleChildrenTypes);
		return this;
	}

	@Override
	public OrganizationUnitType addPossibleChildrenTypes(OrganizationUnitType ... value) {
		addMultiReferenceValue(Arrays.asList(value), possibleChildrenTypes);
		return this;
	}

	@Override
	public OrganizationUnitType removePossibleChildrenTypes(List<OrganizationUnitType> value) {
		removeMultiReferenceValue(value, possibleChildrenTypes);
		return this;
	}

	@Override
	public OrganizationUnitType removePossibleChildrenTypes(OrganizationUnitType ... value) {
		removeMultiReferenceValue(Arrays.asList(value), possibleChildrenTypes);
		return this;
	}

	@Override
	public OrganizationUnitType removeAllPossibleChildrenTypes() {
		removeAllMultiReferenceValue(possibleChildrenTypes);
		return this;
	}

	@Override
	public GeoLocationType getGeoLocationType() {
	    return getEnumValue(geoLocationType, GeoLocationType.values());
	}

	@Override
	public OrganizationUnitType setGeoLocationType(GeoLocationType value) {
    	setEnumValue(this.geoLocationType, value);
		return this;
	}



    @Override
    public UdbOrganizationUnitType save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



